/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query.qe;

import com.microsoft.tfs.core.clients.workitem.exceptions.FieldDefinitionNotExistException;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.internal.query.qe.WIQLTranslatorFieldService;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.ArithmeticalOperators;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Condition;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.ConditionalOperators;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DateTime;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeArithmetic;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeCondition;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeEverOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeNotOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeSelect;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeString;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeValueList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Parser;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.WIQLAdapter;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQuery;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryConnection;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryConnectionType;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryRow;
import com.microsoft.tfs.core.clients.workitem.query.qe.QEQueryRowCollection;
import com.microsoft.tfs.core.clients.workitem.query.qe.WIQLOperators;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import java.text.DateFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class WIQLTranslator {
    private static final char CLOSE_PAREN = ')';
    private static final String CLOSE_PAREN_STRING = ")";
    private static final char OPEN_PAREN = '(';
    private static final String OPEN_PAREN_STRING = "(";
    private static final String MACRO_START = "@";
    private static final String NEXT_ITEM = ", {0}";
    private static final String SELECT = "SELECT";
    private static final String SELECT_ID_FROM_WHERE = "SELECT ID FROM WorkItems WHERE ";
    private static final String SINGLE_QUOTE = "'";
    private static final String TWO_SINGLE_QUOTES = "''";
    private static final String OPERATOR_IN_NEXT_ITEM = "{0} {1}";
    private final QEQuery query;
    private final WIQLTranslatorFieldService fieldService;
    private String parsedWiqlExpression;

    public WIQLTranslator(QEQuery query, WIQLTranslatorFieldService fieldService) {
        this.query = query;
        this.fieldService = fieldService;
    }

    public void fromWIQL(String wiqlString, boolean localizeFieldNames) {
        if (wiqlString == null) {
            throw new IllegalArgumentException("wiqlString cannot be null");
        }
        if (!wiqlString.toUpperCase().startsWith(SELECT)) {
            if (wiqlString.trim().length() > 0) {
                wiqlString = SELECT_ID_FROM_WHERE + wiqlString;
            } else {
                return;
            }
        }
        NodeSelect select1 = Parser.parseSyntax(wiqlString);
        this.parsedWiqlExpression = wiqlString;
        HashMap<NodeCondition, Integer> hashtable1 = new HashMap<NodeCondition, Integer>();
        if (select1.getWhere() != null && select1.getWhere().getCount() > 0) {
            this.parseWIQLNode(select1.getWhere(), "", hashtable1, localizeFieldNames);
            this.processChildGroups(select1.getWhere(), hashtable1);
        }
        if (this.query.getQueryType() == QueryType.LIST) {
            Check.isTrue(this.query.getTargetRowCollection().getRowCount() == 0, "query.getTargetRowCollection().getRowCount() == 0");
            QEQueryRow newRow = this.query.getTargetRowCollection().addRow();
            newRow.setLogicalOperator("");
            newRow.setFieldName(this.getLocalizedFieldName("System.WorkItemType"));
            newRow.setOperator(this.getLocalizedOperator("="));
            newRow.setValue(this.getLocalizedOperator("[Any]"));
        }
    }

    public String asWIQL(boolean localizeFieldNames) {
        StringBuffer sb = new StringBuffer();
        if (this.query.getQueryType() == QueryType.LIST) {
            sb.append(this.rowCollectionAsWIQLCondition(this.query.getSourceRowCollection(), null, localizeFieldNames));
        } else {
            sb.append(this.rowCollectionAsWIQLCondition(this.query.getSourceRowCollection(), "Source", localizeFieldNames));
            sb.append(" ");
            sb.append(WIQLOperators.getInvariantOperator("AND"));
            sb.append(" ");
            if (this.query.getQueryType() == QueryType.ONE_HOP) {
                sb.append(this.linkQueryTypeAsWIQLCondition());
            } else {
                sb.append(this.treeQueryTypeAsWIQLCondition());
            }
            String targetClause = this.rowCollectionAsWIQLCondition(this.query.getTargetRowCollection(), "Target", localizeFieldNames);
            if (targetClause.length() > 0) {
                sb.append(" AND ");
                sb.append(targetClause);
            }
        }
        return sb.toString().trim();
    }

    private String treeQueryTypeAsWIQLCondition() {
        StringBuffer sb = new StringBuffer();
        sb.append("([System.Links.LinkType] = '");
        sb.append(this.query.getTreeQueryLinkType());
        sb.append("')");
        return sb.toString();
    }

    private String linkQueryTypeAsWIQLCondition() {
        StringBuffer sb = new StringBuffer();
        sb.append("([System.Links.LinkType] ");
        String[] referenceNames = this.query.getLinkQueryLinkTypes();
        if (!this.query.getUseSelectedLinkTypes() || referenceNames.length == 0) {
            sb.append("<> ''");
        } else if (referenceNames.length == 1) {
            sb.append("= '");
            sb.append(referenceNames[0]);
            sb.append(SINGLE_QUOTE);
        } else {
            sb.append("IN (");
            for (int i = 0; i < referenceNames.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(SINGLE_QUOTE);
                sb.append(referenceNames[i]);
                sb.append(SINGLE_QUOTE);
            }
            sb.append(CLOSE_PAREN_STRING);
        }
        sb.append(CLOSE_PAREN_STRING);
        return sb.toString();
    }

    private String rowCollectionAsWIQLCondition(QEQueryRowCollection rowCollection, String fieldNamePrefix, boolean localizeFieldNames) {
        StringBuffer sb = new StringBuffer();
        for (int num1 = 0; num1 < rowCollection.getRowCount(); ++num1) {
            int i;
            FieldDefinition fd;
            if (this.skipRow(num1, rowCollection)) continue;
            int num2 = 0;
            int num3 = 0;
            int num4 = rowCollection.getGrouping().getMaxDepth();
            for (int num5 = 1; num5 <= num4; ++num5) {
                QEQueryConnection connection = rowCollection.getGrouping().getConnection(num5, num1);
                if (connection.getType() == QEQueryConnectionType.UP) {
                    ++num3;
                    continue;
                }
                if (connection.getType() != QEQueryConnectionType.DOWN) continue;
                ++num2;
            }
            QEQueryRow row = rowCollection.getRow(num1);
            String fieldName = row.getFieldName();
            String invariantOperator = this.getInvariantOperator(row.getOperator());
            String invariantLogicalOperator = this.getInvariantOperator(row.getLogicalOperator());
            String fieldValue = row.getValue();
            if (WIQLAdapter.fieldSupportsAnySyntax(this.query.getWorkItemClient(), fieldName) && this.isAnySyntax(invariantOperator, fieldValue)) {
                invariantOperator = "<>";
                fieldValue = "";
            }
            if (WIQLOperators.isContainsWordsOperator(invariantOperator) && (fd = this.tryGetFieldDefinition(fieldName)) != null && fd.isLongText()) {
                invariantOperator = this.convertToContains(invariantOperator);
            }
            if (WIQLOperators.isFieldNameOperator(invariantOperator) && fieldValue != null) {
                String referenceName;
                try {
                    referenceName = this.getInvariantFieldName(fieldValue);
                }
                catch (FieldDefinitionNotExistException e) {
                    referenceName = fieldValue;
                }
                StringBuffer sbField = new StringBuffer();
                sbField.append("[");
                sbField.append(referenceName);
                sbField.append("]");
                fieldValue = sbField.toString();
            } else {
                fieldValue = this.getInvariantFieldValue(fieldValue, row);
            }
            fieldName = localizeFieldNames ? this.getLocalizedFieldName(fieldName) : this.getInvariantFieldName(fieldName);
            if (invariantLogicalOperator.length() > 0) {
                sb.append(" ");
                sb.append(invariantLogicalOperator);
                sb.append(" ");
            }
            for (i = 0; i < num2; ++i) {
                sb.append('(');
            }
            if (fieldNamePrefix != null) {
                sb.append("[");
                sb.append(fieldNamePrefix);
                sb.append("].");
            }
            sb.append("[");
            sb.append(fieldName);
            sb.append("] ");
            sb.append(invariantOperator);
            sb.append(" ");
            sb.append(fieldValue);
            for (i = 0; i < num3; ++i) {
                sb.append(')');
            }
        }
        return sb.toString();
    }

    private String getInvariantFieldValue(Object valueObject, QEQueryRow row) {
        String text1 = valueObject == null ? "" : valueObject.toString();
        String text2 = row.getOperator();
        if (!this.getInvariantOperator(text2).equals("IN")) {
            return this.getInvariantFieldValueFromString(text1, row);
        }
        String[] textArray2 = this.splitRemovingEmptyEntries(text1, ",");
        StringBuffer builder1 = new StringBuffer();
        builder1.append('(');
        for (int i = 0; i < textArray2.length; ++i) {
            if (i == 0) {
                builder1.append(this.getInvariantFieldValueFromString(textArray2[i].trim(), row));
                continue;
            }
            builder1.append(MessageFormat.format(NEXT_ITEM, this.getInvariantFieldValueFromString(textArray2[i].trim(), row)));
        }
        builder1.append(')');
        return builder1.toString();
    }

    private String getInvariantFieldValueFromString(String value, QEQueryRow row) {
        boolean flag5;
        boolean flag1 = value.startsWith(MACRO_START);
        boolean flag2 = !flag1 && this.isDateTimeField(row);
        boolean flag3 = !flag1 && this.isDecimalField(row);
        boolean flag4 = !flag1 && this.isStringField(row);
        boolean bl = flag5 = value.length() == 0;
        if (flag1) {
            String localized = WIQLOperators.getLocalizedOperator("@today");
            value = value.startsWith(localized) ? "@today" + value.substring(localized.length()) : this.getInvariantOperator(value);
        } else if (flag2 && !flag5) {
            Date date = DateTime.parse(value, Locale.getDefault(), TimeZone.getDefault());
            value = DateTime.formatRoundTripUnspecified(date, TimeZone.getDefault());
        } else if (flag3 && !flag5) {
            try {
                Number number = NumberFormat.getInstance().parse(value);
                value = number.toString();
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (flag4 || flag2 || flag5) {
            value = SINGLE_QUOTE + value.replaceAll(SINGLE_QUOTE, TWO_SINGLE_QUOTES) + SINGLE_QUOTE;
        }
        return value;
    }

    private String[] splitRemovingEmptyEntries(String input, String delimiters) {
        String[] array = StringUtil.split(delimiters, input);
        ArrayList<String> sections = new ArrayList<String>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i].trim().length() <= 0) continue;
            sections.add(array[i]);
        }
        return sections.toArray(new String[sections.size()]);
    }

    private void processChildGroups(Node node, Map<NodeCondition, Integer> hash) {
        for (int i = 0; i < node.getCount(); ++i) {
            Node node1 = node.getItem(i);
            if (node1.getNodeType() == NodeType.AND || node1.getNodeType() == NodeType.OR) {
                this.processGroupNode(node, node1, hash);
            }
            if (node1.getCount() <= 1) continue;
            this.processChildGroups(node1, hash);
        }
    }

    private void processGroupNode(Node parentNode, Node node, Map<NodeCondition, Integer> hash) {
        if ((node.getNodeType() == NodeType.AND || node.getNodeType() == NodeType.OR) && (node.getPriority().isGreaterThan(parentNode.getPriority()) || this.hasExplicitGrouping(node))) {
            NodeCondition node1 = this.getFirstCondition(node);
            if (node1 == null) {
                throw new RuntimeException("grouping missing first row");
            }
            NodeCondition node2 = this.getLastCondition(node);
            if (node2 == null) {
                throw new RuntimeException("grouping missing last row");
            }
            if (!hash.containsKey(node1) || !hash.containsKey(node2)) {
                throw new RuntimeException("grouping: missing indices");
            }
            int num1 = hash.get(node1);
            int num2 = hash.get(node2);
            String fieldPrefix = node1.getLeft().getPrefix();
            QEQueryRowCollection rowCollection = fieldPrefix == null || fieldPrefix.equalsIgnoreCase("Source") ? this.query.getSourceRowCollection() : this.query.getTargetRowCollection();
            rowCollection.getGrouping().addGrouping(num1, num2);
        }
    }

    private boolean hasExplicitGrouping(Node node) {
        String text1 = WIQLTranslator.wiqlNodeAsString(node, this.parsedWiqlExpression);
        if (text1.startsWith(OPEN_PAREN_STRING)) {
            return text1.endsWith(CLOSE_PAREN_STRING);
        }
        return false;
    }

    public static String wiqlNodeAsString(Node node, String wiqlStatement) {
        if (wiqlStatement == null || node.getStartOffset() < 0 || node.getStartOffset() >= wiqlStatement.length() || node.getEndOffset() < 0 || node.getEndOffset() > wiqlStatement.length()) {
            return "";
        }
        String text1 = node.getEndOffset() == wiqlStatement.length() ? wiqlStatement.substring(node.getStartOffset()) : wiqlStatement.substring(node.getStartOffset(), node.getEndOffset() + 1);
        return text1.trim();
    }

    private NodeCondition getFirstCondition(Node node) {
        if (node != null) {
            if (node.getNodeType() == NodeType.FIELD_CONDITION) {
                return (NodeCondition)node;
            }
            if (node.getCount() > 0) {
                return this.getFirstCondition(node.getItem(0));
            }
        }
        return null;
    }

    private NodeCondition getLastCondition(Node node) {
        if (node != null) {
            if (node.getNodeType() == NodeType.FIELD_CONDITION) {
                return (NodeCondition)node;
            }
            if (node.getCount() > 0) {
                return this.getLastCondition(node.getItem(node.getCount() - 1));
            }
        }
        return null;
    }

    private void parseWIQLNode(Node node, String parentOp, Map<NodeCondition, Integer> hash, boolean localizeFieldNames) {
        if (node != null) {
            if (node.getNodeType() == NodeType.AND || node.getNodeType() == NodeType.OR) {
                for (int i = 0; i < node.getCount(); ++i) {
                    if (i == 0) {
                        this.parseWIQLNode(node.getItem(i), parentOp, hash, localizeFieldNames);
                        continue;
                    }
                    String text1 = node.getNodeType() == NodeType.AND ? "AND" : "OR";
                    this.parseWIQLNode(node.getItem(i), text1, hash, localizeFieldNames);
                }
            } else {
                this.addNodeAsRow(node, localizeFieldNames, parentOp, hash);
            }
        }
    }

    private void addNodeAsRow(Node node, boolean localizeFieldNames, String parentOp, Map<NodeCondition, Integer> hash) {
        FieldDefinition fd;
        String fieldValue;
        String invariantOperator;
        NodeConditionTypeHolder type1 = new NodeConditionTypeHolder();
        NodeCondition nodeCondition = this.getNodeCondition(node, type1);
        if (nodeCondition == null || nodeCondition.getCount() != 2) {
            throw new RuntimeException("unexpected node: " + node.toString());
        }
        Condition condition = nodeCondition.getCondition();
        NodeFieldName nodeFieldName = nodeCondition.getLeft();
        String namePrefix = nodeFieldName.getPrefix();
        if (this.query.getQueryType() != QueryType.LIST && namePrefix == null) {
            this.parseLinkTypesCondition(nodeCondition);
            return;
        }
        QEQueryRowCollection rowCollection = this.query.getQueryType() == QueryType.LIST || namePrefix.equalsIgnoreCase("Source") ? this.query.getSourceRowCollection() : this.query.getTargetRowCollection();
        String fieldName = this.getFieldName(nodeFieldName, localizeFieldNames);
        String localizedOperator = invariantOperator = ConditionalOperators.getString(condition);
        Node nodeRight = nodeCondition.getRight();
        if (nodeRight.getNodeType() == NodeType.FIELD_NAME) {
            localizedOperator = this.getLocalizedOperator(localizedOperator + " ");
            fieldValue = this.getFieldName((NodeFieldName)nodeRight, localizeFieldNames);
        } else {
            if (type1.nodeConditionType == NodeConditionType.NOT) {
                invariantOperator = "NOT " + localizedOperator;
                localizedOperator = this.getLocalizedOperator("NOT " + localizedOperator);
            } else {
                localizedOperator = type1.nodeConditionType == NodeConditionType.NOT_EVER ? this.getLocalizedOperator("NOT EVER") : (type1.nodeConditionType == NodeConditionType.EVER ? this.getLocalizedOperator("EVER") : this.getLocalizedOperator(localizedOperator));
            }
            fieldValue = this.getLocalizedFieldValue(nodeRight);
        }
        String localizedLogicalOperator = this.getLocalizedOperator(rowCollection.getRowCount() > 0 ? parentOp : "");
        if (WIQLAdapter.fieldSupportsAnySyntax(this.query.getWorkItemClient(), fieldName) && this.isAnySyntaxCondition(invariantOperator, fieldValue)) {
            localizedOperator = this.getLocalizedOperator("=");
            fieldValue = this.getLocalizedOperator("[Any]");
        }
        if (WIQLOperators.isContainsOperator(invariantOperator)) {
            fd = this.tryGetFieldDefinition(fieldName);
            if (fd != null && fd.isLongText() && fd.supportsTextQuery()) {
                String replacement = this.convertToContainsWord(invariantOperator);
                localizedOperator = this.getLocalizedOperator(replacement);
            }
        } else if (WIQLOperators.isContainsWordsOperator(invariantOperator) && (fd = this.tryGetFieldDefinition(fieldName)) != null && !fd.supportsTextQuery()) {
            String replacement = this.convertToContains(invariantOperator);
            localizedOperator = this.getLocalizedOperator(replacement);
        }
        QEQueryRow newRow = rowCollection.addRow();
        newRow.setLogicalOperator(localizedLogicalOperator);
        newRow.setFieldName(fieldName);
        newRow.setOperator(localizedOperator);
        newRow.setValue(fieldValue);
        hash.put(nodeCondition, new Integer(rowCollection.indexOf(newRow)));
    }

    private void parseLinkTypesCondition(NodeCondition nodeCondition) {
        Condition condition = nodeCondition.getCondition();
        Node nodeRight = nodeCondition.getRight();
        ArrayList<String> listLinkReferenceNames = new ArrayList<String>();
        if (Condition.EQUALS.equals(condition)) {
            NodeString nodeString = (NodeString)nodeRight;
            listLinkReferenceNames.add(nodeString.getValue());
        } else if (Condition.IN.equals(condition)) {
            NodeValueList nodeValueList = (NodeValueList)nodeRight;
            for (int i = 0; i < nodeValueList.getCount(); ++i) {
                NodeString nodeString = (NodeString)nodeValueList.getItem(i);
                listLinkReferenceNames.add(nodeString.getValue());
            }
        }
        if (this.query.getQueryType() == QueryType.ONE_HOP) {
            this.query.setUseSelectedLinkTypes(listLinkReferenceNames.size() > 0);
            for (int i = 0; i < listLinkReferenceNames.size(); ++i) {
                this.query.addLinkQueryLinkType((String)listLinkReferenceNames.get(i));
            }
        } else if (listLinkReferenceNames.size() > 0) {
            this.query.setTreeQueryLinkType((String)listLinkReferenceNames.get(0));
        }
    }

    private String getLocalizedFieldValue(Node valueNode) {
        if (valueNode.getNodeType() == NodeType.VALUE_LIST) {
            NodeValueList list1 = (NodeValueList)valueNode;
            StringBuffer builder1 = new StringBuffer();
            for (int num1 = 0; num1 < list1.getCount(); ++num1) {
                if (num1 == 0) {
                    builder1.append(this.getLocalizedFieldValueFromValueNode((NodeItem)list1.getItem(num1)));
                    continue;
                }
                builder1.append(MessageFormat.format(OPERATOR_IN_NEXT_ITEM, ",", this.getLocalizedFieldValueFromValueNode((NodeItem)list1.getItem(num1))));
            }
            return builder1.toString();
        }
        if (valueNode.getNodeType() == NodeType.ARITHMETIC) {
            NodeArithmetic arithmetic1 = (NodeArithmetic)valueNode;
            return MessageFormat.format("{0} {1} {2}", this.getLocalizedFieldValueFromValueNode((NodeItem)arithmetic1.getLeft()), ArithmeticalOperators.getString(arithmetic1.getArithmetic()), this.getLocalizedFieldValueFromValueNode((NodeItem)arithmetic1.getRight()));
        }
        return this.getLocalizedFieldValueFromValueNode((NodeItem)valueNode);
    }

    private String getLocalizedFieldValueFromValueNode(NodeItem valueNode) {
        String text1 = valueNode.getValue();
        if (valueNode.getNodeType() == NodeType.VARIABLE) {
            return this.getLocalizedOperator(valueNode.toString());
        }
        if (valueNode.getNodeType() == NodeType.STRING) {
            try {
                Date date = DateTime.parseRoundtripFormat(text1, TimeZone.getDefault());
                text1 = DateFormat.getDateInstance(3).format(date);
            }
            catch (DateTime.UncheckedParseException ex) {
                // empty catch block
            }
        }
        if (valueNode.getNodeType() == NodeType.NUMBER) {
            char decimalSeparator = new DecimalFormatSymbols(Locale.getDefault()).getDecimalSeparator();
            if (text1 != null && text1.indexOf(decimalSeparator) != -1) {
                try {
                    Double d = Double.valueOf(text1);
                    text1 = NumberFormat.getInstance().format(d);
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
        }
        return text1;
    }

    private boolean skipRow(int row, QEQueryRowCollection rowCollection) {
        QEQueryRow qeQueryRow = rowCollection.getRow(row);
        if ((qeQueryRow.getLogicalOperator() != null && qeQueryRow.getLogicalOperator().length() != 0 || row == 0) && qeQueryRow.getFieldName() != null && qeQueryRow.getFieldName().length() != 0) {
            return false;
        }
        return !rowCollection.getGrouping().rowInGroup(row);
    }

    private NodeCondition getNodeCondition(Node node, NodeConditionTypeHolder conditionTypeHolder) {
        NodeCondition condition1 = null;
        if (node.getNodeType() == NodeType.FIELD_CONDITION) {
            conditionTypeHolder.nodeConditionType = NodeConditionType.NORMAL;
            return (NodeCondition)node;
        }
        if (node.getNodeType() == NodeType.NOT) {
            conditionTypeHolder.nodeConditionType = NodeConditionType.NOT;
            NodeNotOperator operator1 = (NodeNotOperator)node;
            if (operator1.getCount() == 1) {
                NodeConditionTypeHolder type1 = new NodeConditionTypeHolder();
                condition1 = this.getNodeCondition(operator1.getItem(0), type1);
                if (type1.nodeConditionType == NodeConditionType.EVER) {
                    conditionTypeHolder.nodeConditionType = NodeConditionType.NOT_EVER;
                }
                return condition1;
            }
            throw new RuntimeException(MessageFormat.format("unexpected node: {0}", node.toString()));
        }
        if (node.getNodeType() != NodeType.EVER) {
            throw new RuntimeException(MessageFormat.format("unexpected node: {0}", node.toString()));
        }
        conditionTypeHolder.nodeConditionType = NodeConditionType.EVER;
        NodeEverOperator operator2 = (NodeEverOperator)node;
        if (operator2.getCount() == 1) {
            NodeConditionTypeHolder type2 = new NodeConditionTypeHolder();
            condition1 = this.getNodeCondition(operator2.getItem(0), type2);
            if (type2.nodeConditionType != NodeConditionType.NORMAL) {
                throw new RuntimeException(MessageFormat.format("unexpected node: {0}", node.toString()));
            }
            return condition1;
        }
        throw new RuntimeException(MessageFormat.format("unexpected node: {0}", node.toString()));
    }

    private boolean isAnySyntax(String invariantOperator, String fieldValue) {
        if (invariantOperator == null || fieldValue == null) {
            return false;
        }
        return invariantOperator.equals("=") && fieldValue.equalsIgnoreCase(WIQLOperators.getLocalizedOperator("[Any]"));
    }

    private boolean isAnySyntaxCondition(String invariantOperator, String fieldValue) {
        if (invariantOperator == null || fieldValue == null) {
            return false;
        }
        return invariantOperator.equals("<>") && fieldValue.length() == 0;
    }

    private String getFieldName(NodeFieldName node, boolean localize) {
        if (localize) {
            return this.getLocalizedFieldName(node.getValue());
        }
        return this.getInvariantFieldName(node.getValue());
    }

    private String getLocalizedFieldName(String fieldName) {
        return this.fieldService.getLocalizedFieldName(fieldName);
    }

    private String getInvariantFieldName(String fieldName) {
        return this.fieldService.getInvariantFieldName(fieldName);
    }

    private String getLocalizedOperator(String invariantOperator) {
        return WIQLOperators.getLocalizedOperator(invariantOperator);
    }

    private String getInvariantOperator(String localizedOperator) {
        return WIQLOperators.getInvariantOperator(localizedOperator);
    }

    private boolean isDateTimeField(QEQueryRow row) {
        return this.fieldService.isDateTimeField(row.getFieldName());
    }

    private boolean isDecimalField(QEQueryRow row) {
        return this.fieldService.isDecimalField(row.getFieldName());
    }

    private boolean isStringField(QEQueryRow row) {
        return this.fieldService.isStringField(row.getFieldName());
    }

    private FieldDefinition tryGetFieldDefinition(String fieldName) {
        try {
            return this.query.getWorkItemClient().getFieldDefinitions().get(fieldName);
        }
        catch (FieldDefinitionNotExistException e) {
            return null;
        }
    }

    private String convertToContainsWord(String containsOperator) {
        if (containsOperator.equalsIgnoreCase("CONTAINS")) {
            return "CONTAINS WORDS";
        }
        if (containsOperator.equalsIgnoreCase("NOT CONTAINS")) {
            return "NOT CONTAINS WORDS";
        }
        throw new IllegalArgumentException("Expected CONTAINS operator");
    }

    private String convertToContains(String containsWordsOperator) {
        if (containsWordsOperator.equalsIgnoreCase("CONTAINS WORDS")) {
            return "CONTAINS";
        }
        if (containsWordsOperator.equalsIgnoreCase("NOT CONTAINS WORDS")) {
            return "NOT CONTAINS";
        }
        throw new IllegalArgumentException("Expected CONTAINS WORDS operator");
    }

    private static class NodeConditionType {
        public static final NodeConditionType NORMAL = new NodeConditionType(0);
        public static final NodeConditionType EVER = new NodeConditionType(1);
        public static final NodeConditionType NOT = new NodeConditionType(2);
        public static final NodeConditionType NOT_EVER = new NodeConditionType(3);
        private final int type;

        private NodeConditionType(int type) {
            this.type = type;
        }

        public String toString() {
            return String.valueOf(this.type);
        }
    }

    private static class NodeConditionTypeHolder {
        public NodeConditionType nodeConditionType;

        private NodeConditionTypeHolder() {
        }
    }
}

