/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Parser;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxException;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.WIQLAdapter;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.LinkQueryMode;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryType;

public final class QueryDefinitionUtil {
    private QueryDefinitionUtil() {
    }

    public static QueryType getQueryType(String queryText) {
        LinkQueryMode queryMode;
        try {
            queryMode = WIQLAdapter.getQueryMode(Parser.parseSyntax(queryText));
        }
        catch (SyntaxException e) {
            return QueryType.INVALID;
        }
        return QueryDefinitionUtil.getQueryType(queryMode);
    }

    public static QueryType getQueryType(LinkQueryMode queryMode) {
        if (LinkQueryMode.LINKS_MUST_CONTAIN.equals(queryMode) || LinkQueryMode.LINKS_MAY_CONTAIN.equals(queryMode) || LinkQueryMode.LINKS_DOES_NOT_CONTAIN.equals(queryMode)) {
            return QueryType.ONE_HOP;
        }
        if (LinkQueryMode.LINKS_RECURSIVE.equals(queryMode)) {
            return QueryType.TREE;
        }
        return QueryType.LIST;
    }

    public static LinkQueryMode getDefaultLinkQueryMode(QueryType queryType) {
        if (QueryType.TREE.equals(queryType)) {
            return LinkQueryMode.LINKS_RECURSIVE;
        }
        if (QueryType.ONE_HOP.equals(queryType)) {
            return LinkQueryMode.LINKS_MAY_CONTAIN;
        }
        return LinkQueryMode.WORK_ITEMS;
    }
}

