/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.workitem.exceptions.WorkItemException;
import com.microsoft.tfs.core.clients.workitem.internal.QueryHierarchyProvider;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryFolderAction;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryFolderImpl;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolder;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItemType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.Date;

public abstract class QueryItemImpl
implements QueryItem {
    private static final char[] INVALID_NAME_CHARACTERS = new char[]{'\u00ab', '\u00bb', '\u2044'};
    private WITContext context;
    private int projectId;
    private GUID id;
    private String name;
    private String originalName;
    private QueryFolder parent;
    private QueryFolder originalParent;
    private IdentityDescriptor ownerDescriptor;
    private IdentityDescriptor originalOwnerDescriptor;
    private Object accessControlList;
    private Object originalAccessControlList;
    private boolean deleted;
    private boolean personal;
    private boolean isNew;

    protected QueryItemImpl(String name, QueryFolder parent) {
        this.isNew = true;
        this.initialize(name, parent, null, null, true);
        if (this.parent != null) {
            this.parent.add(this);
        }
    }

    protected QueryItemImpl(String name, QueryFolder parent, GUID id, IdentityDescriptor ownerDescriptor) {
        this.initialize(name, parent, id, ownerDescriptor, false);
        this.isNew = false;
        this.originalParent = parent;
        if (this.parent != null && this.parent instanceof QueryFolderImpl) {
            ((QueryFolderImpl)this.parent).addInternal(this, false);
        }
    }

    private void initialize(String name, QueryFolder parent, GUID id, IdentityDescriptor ownerDescriptor, boolean checkName) {
        if (checkName) {
            name = QueryItemImpl.checkNameIsValid(name);
        }
        this.id = id == null ? GUID.newGUID() : id;
        this.name = name;
        this.originalName = name;
        this.parent = parent;
        this.ownerDescriptor = ownerDescriptor;
        this.originalOwnerDescriptor = ownerDescriptor;
        if (this.parent != null) {
            this.setProject(this.parent.getProject());
            this.personal = this.parent.isPersonal();
        }
    }

    private static String checkNameIsValid(String name) {
        if (name == null) {
            throw new IllegalArgumentException(Messages.getString("QueryItem.QueryNameCannotBeNull"));
        }
        if ((name = name.trim()).length() > 255) {
            throw new IllegalArgumentException(Messages.getString("QueryItem.QueryNameTooLong"));
        }
        if (!FileHelpers.isValidNTFSFileName(name)) {
            throw new IllegalArgumentException(Messages.getString("QueryItem.QueryNameContainsInvalidCharaacters"));
        }
        for (int i = 0; i < INVALID_NAME_CHARACTERS.length; ++i) {
            if (name.indexOf(INVALID_NAME_CHARACTERS[i]) < 0) continue;
            throw new IllegalArgumentException(Messages.getString("QueryItem.QueryNameContainsInvalidCharaacters"));
        }
        return name;
    }

    protected String checkName(String name) {
        return QueryItemImpl.checkNameIsValid(name);
    }

    @Override
    public GUID getID() {
        return this.id;
    }

    protected void setID(GUID id) {
        this.id = id;
    }

    @Override
    public Project getProject() {
        if (this.context != null) {
            return this.context.getClient().getProjects().getByID(this.projectId);
        }
        return null;
    }

    protected void setProject(Project project) {
        if (project != null) {
            this.context = project.getWITContext();
            this.projectId = project.getID();
        } else {
            this.context = null;
            this.projectId = 0;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }

    @Override
    public void setName(String name) {
        String newName;
        Check.notNull(name, "name");
        if (this.isDeleted()) {
            throw new WorkItemException(Messages.getString("QueryItem.CannotModifyDeletedItems"));
        }
        if (!name.equals(this.name) && !(newName = this.checkName(name)).equals(this.name)) {
            if (this.parent != null && this.parent instanceof QueryFolderImpl) {
                ((QueryFolderImpl)this.parent).checkForDuplicateName(this, newName);
                ((QueryFolderImpl)this.parent).updateName(this, newName);
                ((QueryFolderImpl)this.parent).onContentsChanged(this, QueryFolderAction.CHANGED);
            } else {
                this.name = name;
            }
        }
    }

    protected void setNameInternal(String name) {
        this.name = name;
    }

    protected QueryHierarchyProvider getQueryHierarchyProvider() {
        if (this.context != null) {
            return this.context.getQueryHierarchyProvider();
        }
        return null;
    }

    @Override
    public QueryFolder getParent() {
        return this.parent;
    }

    @Override
    public QueryFolder getOriginalParent() {
        return this.originalParent;
    }

    protected void setParent(QueryFolder parent) {
        if (this.parent != parent) {
            this.parent = parent;
            Project project = this.getProject();
            boolean isPersonal = this.personal;
            if (this.parent != null) {
                this.setProject(this.parent.getProject());
                this.personal = this.parent.isPersonal();
            } else {
                this.setProject(null);
                this.personal = false;
            }
            if (this.getProject() != project || isPersonal != this.personal) {
                this.onMoveChangedHierarchy();
            }
        }
    }

    @Override
    public IdentityDescriptor getOwnerDescriptor() {
        return this.ownerDescriptor;
    }

    @Override
    public IdentityDescriptor getOriginalOwnerDescriptor() {
        return this.originalOwnerDescriptor;
    }

    @Override
    public void setOwnerDescriptor(IdentityDescriptor ownerDescriptor) {
        Project project = this.getProject();
        if (ownerDescriptor != null && project != null && !project.getQueryHierarchy().supportsPermissions()) {
            throw new WorkItemException(Messages.getString("QueryItem.ServerDoesNotSupportPermissions"));
        }
        this.ownerDescriptor = ownerDescriptor;
    }

    @Override
    public void delete() {
        if (this.isDeleted()) {
            throw new WorkItemException(Messages.getString("QueryItem.ItemAlreadyDeleted"));
        }
        if (this.getParent() == null) {
            throw new WorkItemException(Messages.getString("QueryItem.CannotDeleteOrphanedItem"));
        }
        if (this instanceof QueryFolderImpl && ((QueryFolderImpl)this).isRootNode()) {
            throw new WorkItemException(Messages.getString("QueryItem.RootNodesMayNotBeModified"));
        }
        QueryFolder previousParent = this.getParent();
        this.setDeleted(true);
        if (previousParent instanceof QueryFolderImpl) {
            ((QueryFolderImpl)previousParent).deleteInternal(this, true);
            ((QueryFolderImpl)previousParent).onContentsChanged(this, QueryFolderAction.REMOVED);
        }
    }

    @Override
    public boolean isDeleted() {
        if (this.parent == null) {
            return this.deleted;
        }
        if (!this.deleted) {
            return this.parent.isDeleted();
        }
        return true;
    }

    protected void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public boolean isPersonal() {
        return this.personal;
    }

    protected void setPersonal(boolean personal) {
        this.personal = personal;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public boolean isDirty() {
        if (!this.isDirtyShallow()) {
            if (this.accessControlList == null) {
                return this.originalAccessControlList != null;
            }
            return !this.accessControlList.equals(this.originalAccessControlList);
        }
        return true;
    }

    protected boolean isDirtyShallow() {
        if (!this.isNew && !this.deleted && (this.name == null && this.originalName == null || this.name != null && this.originalName != null && this.name.equals(this.originalName)) && (this.ownerDescriptor == null && this.originalOwnerDescriptor == null || this.ownerDescriptor != null && this.originalOwnerDescriptor != null && this.ownerDescriptor.equals(this.originalOwnerDescriptor))) {
            return this.parent != this.originalParent;
        }
        return true;
    }

    protected void resetDirty() {
        this.originalName = this.name;
        this.originalParent = this.parent;
        this.originalOwnerDescriptor = this.ownerDescriptor;
    }

    protected void resetInternal() {
        if (this.isDirty()) {
            this.ownerDescriptor = this.originalOwnerDescriptor;
            this.deleted = false;
            if (this.parent != this.originalParent) {
                if (this.parent != null) {
                    if (this.parent instanceof QueryFolderImpl) {
                        ((QueryFolderImpl)this.parent).deleteInternal(this, true);
                    }
                    this.parent = null;
                }
                this.name = this.originalName;
                if (this.originalParent != null && this.originalParent instanceof QueryFolderImpl) {
                    ((QueryFolderImpl)this.originalParent).addInternal(this, true);
                }
            } else if (this.parent != null && !this.parent.containsID(this.getID())) {
                this.name = this.originalName;
                if (this.parent instanceof QueryFolderImpl) {
                    ((QueryFolderImpl)this.parent).addInternal(this, true);
                }
            } else if (!this.name.equals(this.originalName)) {
                if (this.parent != null && this.parent instanceof QueryFolderImpl) {
                    ((QueryFolderImpl)this.parent).updateName(this, this.originalName);
                }
                this.name = this.originalName;
            }
        }
    }

    protected abstract void validate(WITContext var1);

    protected void onMoveChangedHierarchy() {
    }

    protected void onSaveCompleted() {
        this.originalName = this.name;
        this.originalOwnerDescriptor = this.ownerDescriptor;
        if (this.isNew && !this.deleted) {
            this.isNew = false;
            this.originalParent = this.parent;
            if (this.parent instanceof QueryFolderImpl) {
                ((QueryFolderImpl)this.parent).onAddSaved(this);
            }
        } else if (!this.isNew && this.deleted) {
            QueryFolder originalParent = this.originalParent;
            this.setProject(null);
            this.parent = null;
            this.originalParent = null;
            this.onMoveChangedHierarchy();
            if (originalParent instanceof QueryFolderImpl) {
                ((QueryFolderImpl)originalParent).onDeleteSaved(this);
            }
        } else if (this.parent != this.originalParent) {
            QueryFolder originalParent = this.originalParent;
            this.originalParent = this.parent;
            if (originalParent instanceof QueryFolderImpl) {
                ((QueryFolderImpl)originalParent).onDeleteSaved(this);
            }
            if (this.parent instanceof QueryFolderImpl) {
                ((QueryFolderImpl)this.parent).onAddSaved(this);
            }
        } else if (!this.isNew && this.parent instanceof QueryFolderImpl) {
            ((QueryFolderImpl)this.parent).onUpdateSaved(this);
        }
    }

    public String toString() {
        return MessageFormat.format("{0}:{1}", this.name, this.id);
    }

    public void updateAfterUpdate(Date updateTime) {
    }

    @Override
    public abstract QueryItemType getType();

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof QueryItemImpl) {
            QueryItemImpl o1 = (QueryItemImpl)o;
            return this.getID().equals(o1.getID());
        }
        return false;
    }
}

