/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.update;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.update.BaseUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.query.QueryScope;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.util.Date;
import org.w3c.dom.Element;

public class InsertStoredQueryUpdatePackage
extends BaseUpdatePackage {
    private final StoredQueryImpl query;

    public InsertStoredQueryUpdatePackage(StoredQueryImpl query, WITContext context) {
        super(context);
        this.query = query;
        Element queryElement = DOMUtils.appendChild(this.getRoot(), "InsertQuery");
        DOMUtils.appendChildWithText(queryElement, "ProjectID", String.valueOf(query.getProjectID()));
        DOMUtils.appendChildWithText(queryElement, "Name", query.getName());
        DOMUtils.appendChildWithText(queryElement, "QueryText", query.getQueryText());
        DOMUtils.appendChildWithText(queryElement, "Description", query.getDescription());
        DOMUtils.appendChildWithText(queryElement, "IsPublic", query.getQueryScope() == QueryScope.PUBLIC ? "1" : "0");
    }

    @Override
    protected void handleUpdateResponse(DOMAnyContentType response) {
        Element responseElement = (Element)response.getElements()[0].getElementsByTagName("InsertQuery").item(0);
        String guid = responseElement.getAttribute("QueryID");
        Date updateTime = this.parseDate(responseElement.getAttribute("UpdateTime"));
        this.query.updateAfterSave(new GUID(guid), updateTime);
    }
}

