/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient;

import com.microsoft.tfs.core.httpclient.HttpMethod;
import java.util.HashMap;
import java.util.Map;

public abstract class ActiveHttpMethods {
    private static final ThreadLocal<Object> monitor = new ThreadLocal();
    private static final Map<Object, HttpMethod> methods = new HashMap<Object, HttpMethod>();

    public static void setMonitor(Object mon) {
        if (mon == null) {
            throw new IllegalArgumentException("monitor must not be null");
        }
        monitor.set(mon);
    }

    public static void clearMonitor() {
        monitor.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMethod(HttpMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        Object mon = monitor.get();
        if (mon == null) {
            return;
        }
        Map<Object, HttpMethod> map = methods;
        synchronized (map) {
            methods.put(mon, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMethod() {
        Object mon = monitor.get();
        if (mon == null) {
            return;
        }
        Map<Object, HttpMethod> map = methods;
        synchronized (map) {
            methods.remove(mon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Object, HttpMethod> getMonitorMethods() {
        Map<Object, HttpMethod> map = methods;
        synchronized (map) {
            return new HashMap<Object, HttpMethod>(methods);
        }
    }
}

