/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.internal.auth;

import com.microsoft.tfs.jni.loader.NativeLoader;
import com.microsoft.tfs.util.Check;
import org.apache.commons.logging.LogFactory;

public abstract class NativeAuth {
    public static final short MECHANISM_NTLM = 1;
    public static final short MECHANISM_NEGOTIATE = 2;
    private static long authConfiguration = 0L;

    private NativeAuth() {
    }

    public static boolean authAvailable(short mechanism) {
        return NativeAuth.nativeAuthAvailable(authConfiguration, mechanism);
    }

    public static boolean authSupportsCredentialsDefault(short mechanism) {
        return NativeAuth.nativeAuthSupportsCredentialsDefault(authConfiguration, mechanism);
    }

    public static boolean authSupportsCredentialsSpecified(short mechanism) {
        return NativeAuth.nativeAuthSupportsCredentialsSpecified(authConfiguration, mechanism);
    }

    public static String authGetCredentialsDefault(short mechanism) {
        return NativeAuth.nativeAuthGetCredentialsDefault(authConfiguration, mechanism);
    }

    public static long authInitialize(short mechanism) {
        return NativeAuth.nativeAuthInitialize(authConfiguration, mechanism);
    }

    public static void authSetCredentialsDefault(long authId) {
        Check.isTrue(authId != 0L, "authId != 0");
        NativeAuth.nativeAuthSetCredentialsDefault(authId);
    }

    public static void authSetCredentialsSpecified(long authId, String username, String domain, String password) {
        Check.isTrue(authId != 0L, "authId != 0");
        Check.notNull(username, "username");
        Check.notNull(domain, "domain");
        Check.notNull(password, "password");
        NativeAuth.nativeAuthSetCredentialsSpecified(authId, username, domain, password);
    }

    public static void authSetTarget(long authId, String target) {
        Check.isTrue(authId != 0L, "authId != 0");
        Check.notNull(target, "target");
        NativeAuth.nativeAuthSetTarget(authId, target);
    }

    public static void authSetLocalhost(long authId, String localhost) {
        Check.isTrue(authId != 0L, "authId != 0");
        Check.notNull(localhost, "localhost");
        NativeAuth.nativeAuthSetLocalhost(authId, localhost);
    }

    public static byte[] authGetToken(long authId, byte[] inputToken) {
        Check.isTrue(authId != 0L, "authId != 0");
        return NativeAuth.nativeAuthGetToken(authId, inputToken);
    }

    public static boolean authIsComplete(long authId) {
        Check.isTrue(authId != 0L, "authId != 0");
        return NativeAuth.nativeAuthIsComplete(authId);
    }

    public static String authGetErrorMessage(long authId) {
        Check.isTrue(authId != 0L, "authId != 0");
        return NativeAuth.nativeAuthGetErrorMessage(authId);
    }

    public static void authDispose(long authId) {
        Check.isTrue(authId != 0L, "authId != 0");
        NativeAuth.nativeAuthDispose(authId);
    }

    private static native long nativeAuthConfigure();

    private static native boolean nativeAuthAvailable(long var0, short var2);

    private static native boolean nativeAuthSupportsCredentialsDefault(long var0, short var2);

    private static native boolean nativeAuthSupportsCredentialsSpecified(long var0, short var2);

    private static native String nativeAuthGetCredentialsDefault(long var0, short var2);

    private static native long nativeAuthInitialize(long var0, short var2);

    private static native void nativeAuthSetTarget(long var0, String var2);

    private static native void nativeAuthSetLocalhost(long var0, String var2);

    private static native void nativeAuthSetCredentialsDefault(long var0);

    private static native void nativeAuthSetCredentialsSpecified(long var0, String var2, String var3, String var4);

    private static native byte[] nativeAuthGetToken(long var0, byte[] var2);

    private static native boolean nativeAuthIsComplete(long var0);

    private static native String nativeAuthGetErrorMessage(long var0);

    private static native void nativeAuthDispose(long var0);

    static {
        NativeLoader.loadLibraryAndLogError("native_auth");
        try {
            authConfiguration = NativeAuth.nativeAuthConfigure();
        }
        catch (Throwable t) {
            LogFactory.getLog(NativeAuth.class).error((Object)"Error configuring native authentication library", t);
        }
    }
}

