/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class FindingsComparisonDetailContribution
implements IDetailedInstanceComparisonContribution {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String NON_BLACKLISTED_FINDINGS_BY_CATEGORY_PROPERTY = "nonBlacklistedFindings";
    private static final String TOLERATED_FINDINGS_BY_CATEGORY_PROPERTY = "toleratedFindings";
    private static final String FALSE_POSITIVE_FINDINGS_BY_CATEGORY_PROPERTY = "falsePositiveFindings";
    @JsonProperty(value="nonBlacklistedFindings")
    private final @NonNull Map<String, Set<Finding>> nonBlacklistedFindingsByCategory;
    @JsonProperty(value="toleratedFindings")
    private final @NonNull Map<String, Set<Finding>> toleratedFindingsByCategory;
    @JsonProperty(value="falsePositiveFindings")
    private final @NonNull Map<String, Set<Finding>> falsePositiveFindingsByCategory;

    @JsonCreator
    FindingsComparisonDetailContribution(@JsonProperty(value="nonBlacklistedFindings") @NonNull Map<String, Set<Finding>> nonBlacklistedFindingsByCategory, @JsonProperty(value="toleratedFindings") @NonNull Map<String, Set<Finding>> toleratedFindingsByCategory, @JsonProperty(value="falsePositiveFindings") @NonNull Map<String, Set<Finding>> falsePositiveFindingsByCategory) {
        CCSMAssert.isNotNull(nonBlacklistedFindingsByCategory, () -> String.format("Expected \"%s\" to be not null", NON_BLACKLISTED_FINDINGS_BY_CATEGORY_PROPERTY));
        CCSMAssert.isNotNull(toleratedFindingsByCategory, () -> String.format("Expected \"%s\" to be not null", TOLERATED_FINDINGS_BY_CATEGORY_PROPERTY));
        CCSMAssert.isNotNull(falsePositiveFindingsByCategory, () -> String.format("Expected \"%s\" to be not null", FALSE_POSITIVE_FINDINGS_BY_CATEGORY_PROPERTY));
        this.nonBlacklistedFindingsByCategory = nonBlacklistedFindingsByCategory;
        this.toleratedFindingsByCategory = toleratedFindingsByCategory;
        this.falsePositiveFindingsByCategory = falsePositiveFindingsByCategory;
    }

    public FindingsComparisonDetailContribution() {
        this.nonBlacklistedFindingsByCategory = new HashMap<String, Set<Finding>>();
        this.toleratedFindingsByCategory = new HashMap<String, Set<Finding>>();
        this.falsePositiveFindingsByCategory = new HashMap<String, Set<Finding>>();
    }

    public void addNonBlacklistedFinding(String category, TrackedFinding finding) {
        FindingsComparisonDetailContribution.addFinding(this.nonBlacklistedFindingsByCategory, category, finding);
    }

    public UnmodifiableSet<Finding> getNonBlacklistedFindings(String category) {
        return CollectionUtils.asUnmodifiable(this.nonBlacklistedFindingsByCategory.getOrDefault(category, Collections.emptySet()));
    }

    public void addToleratedFinding(String category, TrackedFinding finding) {
        FindingsComparisonDetailContribution.addFinding(this.toleratedFindingsByCategory, category, finding);
    }

    public UnmodifiableSet<Finding> getToleratedFindings(String category) {
        return CollectionUtils.asUnmodifiable(this.toleratedFindingsByCategory.getOrDefault(category, Collections.emptySet()));
    }

    public void addFalsePositiveFinding(String category, TrackedFinding finding) {
        FindingsComparisonDetailContribution.addFinding(this.falsePositiveFindingsByCategory, category, finding);
    }

    public UnmodifiableSet<Finding> getFalsePositiveFindings(String category) {
        return CollectionUtils.asUnmodifiable(this.falsePositiveFindingsByCategory.getOrDefault(category, Collections.emptySet()));
    }

    private static void addFinding(Map<String, Set<Finding>> container, String category, TrackedFinding finding) {
        container.computeIfAbsent(category, ignored -> new HashSet()).add(new Finding(finding));
    }

    @Override
    public @NonNull Map<String, DetailedInstanceComparisonValue> getDetailedValues(String category) {
        TreeMap<String, @Nullable DetailedInstanceComparisonValue> result = new TreeMap<String, DetailedInstanceComparisonValue>();
        FindingsComparisonDetailContribution.insertDetailedValues(this.nonBlacklistedFindingsByCategory, category, null, result);
        FindingsComparisonDetailContribution.insertDetailedValues(this.toleratedFindingsByCategory, category, EFindingBlacklistType.TOLERATION, result);
        FindingsComparisonDetailContribution.insertDetailedValues(this.falsePositiveFindingsByCategory, category, EFindingBlacklistType.FALSE_POSITIVE, result);
        return result;
    }

    private static void insertDetailedValues(@NonNull Map<String, Set<Finding>> container, String category, @Nullable EFindingBlacklistType blacklistType, @NonNull Map<String, @Nullable DetailedInstanceComparisonValue> target) {
        Set<@NonNull T> findings = container.getOrDefault(category, Collections.emptySet());
        for (Finding finding : findings) {
            FindingsComparisonDetailContribution.insertDetailedValue(finding, blacklistType, target);
        }
    }

    private static void insertDetailedValue(@NonNull Finding finding, @Nullable EFindingBlacklistType blacklistType, @NonNull Map<String, @Nullable DetailedInstanceComparisonValue> target) {
        DetailedInstanceComparisonValue value;
        String key = FindingsComparisonDetailContribution.toComparableKey(finding, blacklistType);
        DetailedInstanceComparisonValue currentValueForSameKey = target.putIfAbsent(key, value = FindingsComparisonDetailContribution.toDetailedInstanceComparisonValue(finding, blacklistType));
        if (currentValueForSameKey != null) {
            LOGGER.warn("Calculated duplicate comparison key \"{}\" for different findings \"{}\" and \"{}\"", (Object)key, (Object)value, (Object)currentValueForSameKey);
        }
    }

    static String toComparableKey(@NonNull Finding finding, @Nullable EFindingBlacklistType blacklistType) {
        String blacklistTypeName = blacklistType != null ? blacklistType.name() : "";
        return String.join((CharSequence)"|", finding.getLocation(), blacklistTypeName);
    }

    private static DetailedInstanceComparisonValue toDetailedInstanceComparisonValue(@NonNull Finding finding, @Nullable EFindingBlacklistType blacklistType) {
        return DetailedInstanceComparisonValue.ofFinding(finding.getId(), finding.getLocation(), blacklistType);
    }

    public void moveFindings(String oldCategory, String newCategory) {
        this.nonBlacklistedFindingsByCategory.put(newCategory, CollectionUtils.emptyIfNull(this.nonBlacklistedFindingsByCategory.get(oldCategory)));
        this.nonBlacklistedFindingsByCategory.remove(oldCategory);
        this.toleratedFindingsByCategory.put(newCategory, CollectionUtils.emptyIfNull(this.toleratedFindingsByCategory.get(oldCategory)));
        this.toleratedFindingsByCategory.remove(oldCategory);
        this.falsePositiveFindingsByCategory.put(newCategory, CollectionUtils.emptyIfNull(this.falsePositiveFindingsByCategory.get(oldCategory)));
        this.falsePositiveFindingsByCategory.remove(oldCategory);
    }

    @IndexValueClass
    public static class Finding
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String ID_PROPERTY = "id";
        private static final String LOCATION_PROPERTY = "location";
        private static final String TYPE_ID_PROPERTY = "typeId";
        @JsonProperty(value="id")
        private final String id;
        @JsonProperty(value="location")
        private final String location;
        @JsonProperty(value="typeId")
        private final String typeId;

        public Finding(TrackedFinding finding) {
            this.id = finding.getId();
            this.location = finding.getLocationPathString();
            this.typeId = finding.getTypeId();
        }

        @JsonCreator
        Finding(@JsonProperty(value="id") String id, @JsonProperty(value="location") String location, @JsonProperty(value="typeId") String typeId) {
            this.id = id;
            this.location = location;
            this.typeId = typeId;
        }

        public String getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Finding finding = (Finding)o;
            return Objects.equals(this.id, finding.id) && Objects.equals(this.location, finding.location) && Objects.equals(this.typeId, finding.typeId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.location, this.typeId);
        }
    }
}

