/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.index.architecture.assessment.shared.CodeMapping;
import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.commons.EStereotype;
import com.teamscale.index.architecture.format.EArchitectureIOAttribute;
import com.teamscale.index.architecture.format.EArchitectureIOElement;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.architecture.scope.Constraint;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import java.awt.Dimension;
import java.awt.Point;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.xml.IXMLResolver;
import org.conqat.lib.commons.xml.LowercaseResolver;
import org.conqat.lib.commons.xml.XMLWriter;

public class ArchitectureXMLWriter
extends XMLWriter<EArchitectureIOElement, EArchitectureIOAttribute> {
    protected final ArchitectureDefinition architecture;
    protected final PublicProjectId projectId;

    public ArchitectureXMLWriter(OutputStream outputStream, ArchitectureDefinition architecture, PublicProjectId projectId) {
        super(outputStream, (IXMLResolver)new LowercaseResolver(EArchitectureIOAttribute.class));
        this.architecture = architecture;
        this.projectId = projectId;
    }

    public void writeArchitecture() {
        this.writeHeader();
        this.writeExportInformation();
        this.openElement(EArchitectureIOElement.CONQAT_ARCHITECTURE);
        this.writeArchitectureAttributes();
        this.writeConstraints();
        this.writeComponents();
        this.writePolicies();
        this.closeElement(EArchitectureIOElement.CONQAT_ARCHITECTURE);
        this.close();
    }

    private void writeHeader() {
        this.addHeader("1.0", StandardCharsets.UTF_8);
    }

    private void writeComponents() {
        if (this.architecture.hasSubComponents()) {
            ArrayList<ComponentNode> children = new ArrayList<ComponentNode>(this.architecture.getSubComponents());
            Collections.sort(children, new Comparator<ComponentNode>(this){

                @Override
                public int compare(ComponentNode c1, ComponentNode c2) {
                    return c1.getName().compareTo(c2.getName());
                }
            });
            for (ComponentNode topLevelComponent : children) {
                this.writeComponent(topLevelComponent);
            }
        }
    }

    private void writeComponent(ComponentNode component) {
        this.openElement(EArchitectureIOElement.COMPONENT);
        this.writeComponentAttributes(component);
        this.writeCodeMappings(component);
        this.writeComment(component);
        this.writeSpecItemMapping(component);
        if (component.hasSubComponents()) {
            for (ComponentNode childComponent : component.getSubComponents()) {
                this.writeComponent(childComponent);
            }
        }
        this.closeElement(EArchitectureIOElement.COMPONENT);
    }

    private void writeArchitectureAttributes() {
        this.addAttribute(EArchitectureIOAttribute.XMLNS, "http://conqat.cs.tum.edu/ns/architecture");
        this.addAttribute(EArchitectureIOAttribute.POLICY, "deny");
        this.addAttribute(EArchitectureIOAttribute.FILE_BASED, this.architecture.isFileBased());
        this.addAttribute(EArchitectureIOAttribute.LEGACY_CODE_MAPPING, this.architecture.isLegacyCodeMapping());
        this.addAttribute(EArchitectureIOAttribute.STRUCTURE_ONLY, this.architecture.isStructureOnly());
        this.addAttribute(EArchitectureIOAttribute.FINDING_CREATION, (Object)this.architecture.getFindingCreation());
        this.addAttribute(EArchitectureIOAttribute.SCOPE_INCLUDE, this.architecture.getScopeIncludePattern());
        this.addAttribute(EArchitectureIOAttribute.SCOPE_EXCLUDE, this.architecture.getScopeExcludePattern());
        if (this.architecture.getCreationAndModificationInfo().getCreatedBy() != null) {
            this.addAttribute(EArchitectureIOAttribute.CREATED_BY, this.architecture.getCreationAndModificationInfo().getCreatedBy());
            this.addAttribute(EArchitectureIOAttribute.CREATION_DATE, this.architecture.getCreationAndModificationInfo().getCreationDate());
        }
        if (this.architecture.getCreationAndModificationInfo().getLastModifiedBy() != null) {
            this.addAttribute(EArchitectureIOAttribute.LAST_MODIFIED_BY, this.architecture.getCreationAndModificationInfo().getLastModifiedBy());
            this.addAttribute(EArchitectureIOAttribute.MODIFICATION_DATE, this.architecture.getCreationAndModificationInfo().getModificationDate());
        }
    }

    private void writeComponentAttributes(ComponentNode component) {
        this.addAttribute(EArchitectureIOAttribute.NAME, component.getName());
        Dimension dimension = component.getDimension();
        this.addAttribute(EArchitectureIOAttribute.DIM, dimension.width + "," + dimension.height);
        Point position = component.getPosition();
        this.addAttribute(EArchitectureIOAttribute.POS, position.x + "," + position.y);
        if (component.getStereotype() != EStereotype.NONE) {
            this.addAttribute(EArchitectureIOAttribute.STEREOTYPE, component.getStereotype().toString().toLowerCase());
        }
    }

    private void writePolicies() {
        for (DependencyPolicy policy : this.architecture.getSortedPolicies()) {
            this.writePolicy(policy);
        }
    }

    private void writePolicy(DependencyPolicy policy) {
        this.openElement(ArchitectureXMLWriter.getPolicyType(policy));
        this.writePolicyAttributes(policy);
        this.writeDependencies(policy);
        this.closeElement(ArchitectureXMLWriter.getPolicyType(policy));
    }

    private static EArchitectureIOElement getPolicyType(Dependency policy) {
        String type = policy.getType().toString().replaceAll("_EXPLICIT|_IMPLICIT", "");
        return EArchitectureIOElement.valueOf(type);
    }

    private void writeCodeMappings(ComponentNode component) {
        for (CodeMapping mapping : component.getCodeMappings()) {
            this.openElement(EArchitectureIOElement.CODE_MAPPING);
            this.addAttribute(EArchitectureIOAttribute.TYPE, (Object)mapping.getType());
            this.addAttribute(EArchitectureIOAttribute.REGEX, mapping.getPattern());
            this.closeElement(EArchitectureIOElement.CODE_MAPPING);
        }
    }

    private void writeComment(ComponentNode component) {
        if (!component.getDescription().equals("")) {
            this.openElement(EArchitectureIOElement.COMMENT);
            this.addText(component.getDescription());
            this.closeElement(EArchitectureIOElement.COMMENT);
        }
    }

    private void writeSpecItemMapping(ComponentNode component) {
        if (component.getSpecItemMapping() != null) {
            this.openElement(EArchitectureIOElement.SPEC_ITEM_MAPPING);
            this.addText(component.getSpecItemMapping());
            this.closeElement(EArchitectureIOElement.SPEC_ITEM_MAPPING);
        }
    }

    private void writePolicyAttributes(DependencyPolicy policy) throws AssertionError {
        this.addAttribute(EArchitectureIOAttribute.SOURCE, policy.getSource().getName());
        this.addAttribute(EArchitectureIOAttribute.TARGET, policy.getTarget().getName());
        StringBuilder points = new StringBuilder();
        for (Point point : policy.getPoints()) {
            String pointString = point.x + "," + point.y;
            points.append(pointString).append(",");
        }
        if (points.length() > 1) {
            points.deleteCharAt(points.length() - 1);
            this.addAttribute(EArchitectureIOAttribute.POINTS, points.toString());
        }
    }

    private void writeDependencies(DependencyPolicy policy) {
        Set<TypeDependency> toleratedDependencies = policy.getToleratedDependencies();
        if (!toleratedDependencies.isEmpty()) {
            for (TypeDependency typeDependency : toleratedDependencies) {
                this.writeDependency(typeDependency.getSource(), typeDependency.getTarget());
            }
        }
    }

    private void writeDependency(String source, String target) {
        this.addClosedElement(EArchitectureIOElement.DEPENDENCY, new Object[]{EArchitectureIOAttribute.SOURCE, source, EArchitectureIOAttribute.TARGET, target});
    }

    private void writeExportInformation() {
        String name = "Architecture: " + this.architecture.getName();
        String project = "Project: " + String.valueOf(this.projectId);
        String exportedAt = "Exported at: " + String.valueOf(DateTimeUtils.now());
        String exportInformation = "\n" + name + "\n" + project + "\n" + exportedAt + "\n";
        this.addComment(exportInformation);
    }

    private void writeConstraints() {
        for (Constraint constraint : this.architecture.getConstraints()) {
            this.openElement(EArchitectureIOElement.CONSTRAINT);
            this.addAttribute(EArchitectureIOAttribute.SOURCE, constraint.getSourcePattern());
            this.addAttribute(EArchitectureIOAttribute.TARGET, constraint.getTargetPattern());
            this.closeElement(EArchitectureIOElement.CONSTRAINT);
        }
    }
}

