/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.AnalysisContributorBase;
import com.teamscale.core.analysis.configuration.ConfigurationTemplateManager;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.QualityIndicatorTemplate;
import com.teamscale.index.configuration.ArchitectureAnalysisConfiguration;
import com.teamscale.index.configuration.BinarySizeAnalysisConfiguration;
import com.teamscale.index.configuration.ChecksConfiguration;
import com.teamscale.index.configuration.CloningConfiguration;
import com.teamscale.index.configuration.CommentAnalysisConfiguration;
import com.teamscale.index.configuration.CompilationDatabasesConfiguration;
import com.teamscale.index.configuration.CopyrightLicenseAnalysisConfiguration;
import com.teamscale.index.configuration.CoreConfiguration;
import com.teamscale.index.configuration.DataflowAnalysisConfiguration;
import com.teamscale.index.configuration.FileMetadataConfiguration;
import com.teamscale.index.configuration.InconsistentCloneChangeAlertConfiguration;
import com.teamscale.index.configuration.LanguageAdjustmentConfiguration;
import com.teamscale.index.configuration.NamingConventionConfiguration;
import com.teamscale.index.configuration.PreCommitAnalysisConfiguration;
import com.teamscale.index.configuration.RedundantLiteralAnalysisConfiguration;
import com.teamscale.index.configuration.RepositoryConfiguration;
import com.teamscale.index.configuration.ResourceConfiguration;
import com.teamscale.index.configuration.ReviewAnalysisConfiguration;
import com.teamscale.index.configuration.SimulinkAnalysisConfiguration;
import com.teamscale.index.configuration.SimulinkCloneConfiguration;
import com.teamscale.index.configuration.SimulinkNamingConventionAnalysisConfiguration;
import com.teamscale.index.configuration.StructuringConfiguration;
import com.teamscale.index.configuration.SwiftLanguageAdjustmentConfiguration;
import com.teamscale.index.configuration.TaintAnalysisConfiguration;
import com.teamscale.index.configuration.TeamAnalysisConfiguration;
import com.teamscale.index.configuration.TestCoverageConfiguration;
import com.teamscale.index.configuration.TestGapConfiguration;
import com.teamscale.index.configuration.TestSupportConfiguration;
import com.teamscale.index.configuration.WorkItemCoreConfiguration;
import com.teamscale.index.configuration.WorkItemMetricsCoreConfiguration;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.lib.commons.function.ConsumerWithException;

public class AnalysisContributor
extends AnalysisContributorBase {
    public AnalysisContributor() {
        this.registerContributor(CoreConfiguration::new);
        this.registerContributor(StructuringConfiguration::new);
        this.registerContributor(RepositoryConfiguration::new);
        this.registerContributor(() -> new ResourceConfiguration(this.globalStorageSystem));
        this.registerContributor(FileMetadataConfiguration::new, LanguageGroups.SAP_LANGUAGES);
        this.registerContributor(LanguageAdjustmentConfiguration::new, LanguageGroups.C_AND_DERIVATIVES);
        this.registerContributor(CompilationDatabasesConfiguration::new, LanguageGroups.C_AND_DERIVATIVES);
        this.registerContributor(SwiftLanguageAdjustmentConfiguration::new, new ELanguage[]{ELanguage.SWIFT});
        this.registerContributor(CloningConfiguration::new);
        this.registerCodeOnlyContributor(CommentAnalysisConfiguration::new);
        this.registerContributor(PreCommitAnalysisConfiguration::new);
        this.registerContributor(ArchitectureAnalysisConfiguration::new);
        this.registerContributor(NamingConventionConfiguration::new);
        this.registerContributor(TestCoverageConfiguration::new);
        this.registerContributor(SimulinkAnalysisConfiguration::new, new ELanguage[]{ELanguage.SIMULINK});
        this.registerContributor(SimulinkNamingConventionAnalysisConfiguration::new, new ELanguage[]{ELanguage.SIMULINK});
        this.registerContributor(SimulinkCloneConfiguration::new, new ELanguage[]{ELanguage.SIMULINK});
        if (EFeatureToggle.ENABLE_EXPERIMENTAL_BINARY_SIZE_CHECKS.isEnabled()) {
            this.registerContributor(BinarySizeAnalysisConfiguration::new, BinarySizeAnalysisConfiguration.SUPPORTED_LANGUAGES);
        }
        this.registerContributor(ChecksConfiguration::new);
        this.registerContributor(WorkItemCoreConfiguration::new);
        this.registerContributor(WorkItemMetricsCoreConfiguration::new);
        this.registerContributor(DataflowAnalysisConfiguration::new);
        this.registerContributor(TaintAnalysisConfiguration::new);
        this.registerContributor(TestGapConfiguration::new);
        this.registerContributor(TestSupportConfiguration::new);
        this.registerCodeOnlyContributor(RedundantLiteralAnalysisConfiguration::new);
        this.registerCodeOnlyContributor(CopyrightLicenseAnalysisConfiguration::new);
        this.registerContributor(TeamAnalysisConfiguration::new);
        this.registerContributor(InconsistentCloneChangeAlertConfiguration::new);
        this.registerCodeOnlyContributor(ReviewAnalysisConfiguration::new);
    }

    public int orderingHint() {
        return -2147483647;
    }

    public void contributeToTemplates(ConfigurationTemplateManager templateManager, CodeScopeAware<Set<ELanguage>> languagesPerCodeScope, CodeScopeAware<Set<EAnalysisTool>> toolsPerCodeScope, GlobalStorageSystem storageSystem) throws ProjectConfigurationException {
        super.contributeToTemplates(templateManager, languagesPerCodeScope, toolsPerCodeScope, storageSystem);
        AnalysisContributor.enableQualityIndicatorOptionsForDefaultDashboards(templateManager);
    }

    private static void enableQualityIndicatorOptionsForDefaultDashboards(ConfigurationTemplateManager templateManager) throws ProjectConfigurationException {
        AnalysisContributor.adjustIndicatorIfAvailable(templateManager, Set.of("Architecture"), (ConsumerWithException<QualityIndicatorTemplate, ProjectConfigurationException>)((ConsumerWithException)categoryTemplate -> {
            categoryTemplate.getOption("Findings Density (Red)").setValueAndDefaultValue("true", CodeScopeAware.DEFAULT_CODE_SCOPE);
            categoryTemplate.getOption("Findings Density (Yellow)").setValueAndDefaultValue("true", CodeScopeAware.DEFAULT_CODE_SCOPE);
        }));
        AnalysisContributor.adjustIndicatorIfAvailable(templateManager, Set.of("Comprehensibility", "Documentation", "Correctness", "Error Handling"), (ConsumerWithException<QualityIndicatorTemplate, ProjectConfigurationException>)((ConsumerWithException)categoryTemplate -> {
            categoryTemplate.getOption("Number of Findings (Red)").setValueAndDefaultValue("true", CodeScopeAware.DEFAULT_CODE_SCOPE);
            categoryTemplate.getOption("Findings Density").setValueAndDefaultValue("true", CodeScopeAware.DEFAULT_CODE_SCOPE);
        }));
    }

    private static void adjustIndicatorIfAvailable(ConfigurationTemplateManager templateManager, Set<String> qualityCategories, ConsumerWithException<QualityIndicatorTemplate, ProjectConfigurationException> adjuster) throws ProjectConfigurationException {
        for (String category : qualityCategories) {
            QualityIndicatorTemplate categoryTemplate = templateManager.getConfigurationTemplate(CodeScopeAware.DEFAULT_CODE_SCOPE).getQualityIndicator(category);
            if (categoryTemplate == null) continue;
            adjuster.accept((Object)categoryTemplate);
        }
    }
}

