/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.ProjectValidationUtils;
import com.teamscale.index.configuration.service.EMetricThresholdConfigurationVersion;
import jakarta.ws.rs.ForbiddenException;
import java.util.Map;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class MetricThresholdConfigurationUtils {
    public static MetricThresholdConfiguration parseAndMigrateThresholdConfiguration(ObjectNode jsonData, Map<String, ObjectNode> jsonDataByThresholdConfigName) throws MigrationException {
        String payloadReadableName = "metric threshold configuration";
        String json = EMetricThresholdConfigurationVersion.removeBaseConfigurationNameProperty(jsonData, payloadReadableName, jsonDataByThresholdConfigName);
        return (MetricThresholdConfiguration)TeamscaleVersionContainer.fromJson((String)json, null, MetricThresholdConfiguration.class, (Enum)EMetricThresholdConfigurationVersion.CURRENT_VERSION, (String)payloadReadableName);
    }

    public static MetricThresholdConfiguration createMetricThresholdConfiguration(ObjectNode data, MetricThresholdConfigurationIndex metricThresholdIndex, @Nullable ServicePermissions permissions, boolean validate, GlobalStorageSystem globalStorageSystem, Map<String, ObjectNode> jsonDataByThresholdConfigName) throws MigrationException {
        MetricThresholdConfiguration metricThresholdConfiguration = MetricThresholdConfigurationUtils.parseAndMigrateThresholdConfiguration(data, jsonDataByThresholdConfigName);
        try {
            if (validate) {
                MetricThresholdConfigurationUtils.validateMetricThresholdConfiguration(metricThresholdConfiguration, globalStorageSystem);
            }
            if (permissions != null) {
                MetricThresholdConfiguration currentMetricThresholdConfiguration = metricThresholdIndex.getConfiguration(metricThresholdConfiguration.getName());
                if (currentMetricThresholdConfiguration == null) {
                    permissions.checkGlobalPermission(EGlobalPermission.CREATE_METRIC_THRESHOLD_CONFIGURATIONS);
                } else {
                    permissions.checkBasicPermission(EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, metricThresholdConfiguration.getName(), EBasicPermission.EDIT);
                }
            }
            metricThresholdIndex.setThresholdConfiguration(metricThresholdConfiguration);
            return metricThresholdConfiguration;
        }
        catch (MetricThresholdConfigurationException e) {
            throw new MigrationException("Configuration is invalid: " + e.getMessage(), (Throwable)e);
        }
        catch (StorageException e) {
            throw new MigrationException("Storage error during creation of metric threshold configuration: " + e.getMessage(), (Throwable)e);
        }
        catch (ForbiddenException e) {
            throw new MigrationException("Permission issues during creation of metric threshold configuration: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void validateMetricThresholdConfiguration(MetricThresholdConfiguration metricThresholdConfiguration, GlobalStorageSystem globalStorageSystem) throws StorageException, MetricThresholdConfigurationException {
        metricThresholdConfiguration.adjustAndValidateData();
        ProjectValidationUtils.validateMetricThresholdConfiguration(metricThresholdConfiguration, globalStorageSystem);
    }

    private MetricThresholdConfigurationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

