/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.migration.IJsonFileVersion;
import com.teamscale.core.migration.JsonMigrator;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass
public enum EMetricThresholdConfigurationVersion implements IJsonFileVersion<MetricThresholdConfiguration, Void>,
MetaIndex.IMetaIndexEntry
{
    THRESHOLD_CONFIGURATION_VERSION_8{

        public @NonNull JsonMigrator getMigrator(String json, Void context) {
            throw new UnsupportedOperationException();
        }
    }
    ,
    THRESHOLD_CONFIGURATION_VERSION_9{

        public @NonNull JsonMigrator getMigrator(String json, Void context) {
            return JsonMigrator.NO_OP_MIGRATOR;
        }
    };

    private static final Logger LOGGER;
    public static final EMetricThresholdConfigurationVersion CURRENT_VERSION;

    public static String removeBaseConfigurationNameProperty(ObjectNode jsonData, String payloadReadableName, Map<String, ObjectNode> jsonDataByThresholdConfigName) throws MigrationException {
        String json = jsonData.toString();
        EMetricThresholdConfigurationVersion currentVersion = (EMetricThresholdConfigurationVersion)((Object)TeamscaleVersionContainer.extractVersion((String)json, EMetricThresholdConfigurationVersion.class).orElseThrow(() -> new MigrationException(TeamscaleVersionContainer.createInvalidVersionErrorMessage((String)payloadReadableName) + json)));
        if (currentVersion == THRESHOLD_CONFIGURATION_VERSION_8 && jsonData.has("baseConfigurationName")) {
            return EMetricThresholdConfigurationVersion.inlineBaseConfigurations(jsonData, jsonDataByThresholdConfigName).toString();
        }
        return json;
    }

    private static ObjectNode inlineBaseConfigurations(ObjectNode configuration, Map<String, ObjectNode> jsonDataByThresholdConfigName) {
        LinkedHashSet<String> configurationNames = new LinkedHashSet<String>();
        configurationNames.addFirst(configuration.get("name").asText());
        JsonNode currentBaseConfigurationName = configuration.get("baseConfigurationName");
        while (currentBaseConfigurationName != null) {
            if (!jsonDataByThresholdConfigName.containsKey(currentBaseConfigurationName.asText())) {
                LOGGER.warn("Base configuration " + currentBaseConfigurationName.asText() + " not found.");
                break;
            }
            if (configurationNames.contains(currentBaseConfigurationName.asText())) {
                LOGGER.warn("Loop found in the base configuration hierarchy when retrieving base configuration of " + currentBaseConfigurationName.asText() + ".");
                break;
            }
            configurationNames.addFirst(currentBaseConfigurationName.asText());
            currentBaseConfigurationName = jsonDataByThresholdConfigName.get(currentBaseConfigurationName.asText()).get("baseConfigurationName");
        }
        LinkedHashMap<String, LinkedHashMap> groupNameToThresholdNameMap = new LinkedHashMap<String, LinkedHashMap>();
        for (String configurationName : configurationNames) {
            ObjectNode baseConfiguration = jsonDataByThresholdConfigName.get(configurationName);
            for (JsonNode thresholdGroup : baseConfiguration.get("metricThresholdGroupList")) {
                LinkedHashMap group = groupNameToThresholdNameMap.computeIfAbsent(thresholdGroup.get("name").asText(), name -> new LinkedHashMap());
                for (JsonNode threshold : thresholdGroup.get("metricThresholdList")) {
                    group.put(threshold.has("customName") ? threshold.get("customName").asText() : threshold.get("name").asText(), threshold);
                }
            }
        }
        ArrayNode resolvedGroups = JsonUtils.getObjectMapper().createArrayNode();
        for (Map.Entry groupWithName : groupNameToThresholdNameMap.entrySet()) {
            ObjectNode group = JsonUtils.getObjectMapper().createObjectNode();
            resolvedGroups.add((JsonNode)group);
            group.put("name", (String)groupWithName.getKey());
            ArrayNode metricThresholdList = JsonUtils.getObjectMapper().createArrayNode();
            group.set("metricThresholdList", (JsonNode)metricThresholdList);
            for (JsonNode threshold : ((LinkedHashMap)groupWithName.getValue()).values()) {
                metricThresholdList.add(threshold);
            }
        }
        configuration.set("metricThresholdGroupList", (JsonNode)resolvedGroups);
        return configuration;
    }

    static {
        LOGGER = LogManager.getLogger();
        CURRENT_VERSION = EMetricThresholdConfigurationVersion.values()[EMetricThresholdConfigurationVersion.values().length - 1];
    }
}

