/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.findings.abaplint.ABAPLintFindingsSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jspecify.annotations.NonNull;

public class ABAPLintConfiguration
extends ToolConfigurationBase {
    private static ABAPLintConfiguration instance;
    public static final String FINDING_CATEGORY = "abaplint";
    private static final String DESCRIPTIONS_PATH = "abaplint";
    public static final String ABAPLINT_MAPPINGS_TSV = "abaplint/check-mappings.tsv";
    public static final String ABAPLINT_OPTIONS_TSV = "abaplint/check-options.tsv";
    public static final String ABAPLINT_CONFIGURATION_DEFAULT_LANGUAGE_OPTION_NAME = "abaplint default language";
    @ConfigExposed(name="abaplint default language", description="The ABAP language version to be used by abaplint. If no value is specified, Teamscale will use the SAP system's ABAP version (when using the Teamscale ABAP Connector) or default to v740sp08 (for abapGit repositories).")
    public CodeScopeAware<String> defaultLanguage = CodeScopeAware.defaultCodeScopeWithValue((Object)"");

    public ABAPLintConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.ABAPLINT, "abaplint", "abaplint", ABAPLINT_MAPPINGS_TSV, ABAPLINT_OPTIONS_TSV, "");
        this.declareCodeScopeAware();
    }

    public static synchronized ABAPLintConfiguration getInstance() throws ProjectConfigurationException {
        if (instance == null) {
            instance = new ABAPLintConfiguration();
        }
        return instance;
    }

    public void validateTools() throws ProjectConfigurationException {
        super.validateTools();
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware selectedChecksPerCodeScope = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (selectedChecksPerCodeScope == null) {
            return;
        }
        TriggerBuilder triggerBuilder = new TriggerBuilder(ABAPLintFindingsSynchronizer.class, ETriggerConcurrency.PARALLEL);
        triggerBuilder.setCost(ETriggerCost.EXPENSIVE);
        triggerBuilder.setTriggerParameter("default-language", this.defaultLanguage);
        triggerBuilder.setTriggerParameter("checks", ITriggerParameter.of((Object)selectedChecksPerCodeScope));
        List codeScopeNames = selectedChecksPerCodeScope.getCodeScopeNames();
        CodeScopeAware checkOptions = ABAPLintConfiguration.initializeWithEmptyLists(codeScopeNames);
        for (CodeScopeName codeScopeName : codeScopeNames) {
            for (String check : (Collection)selectedChecksPerCodeScope.getValue(codeScopeName)) {
                UnmodifiableSet options = ((FindingDescriptor)((Map)this.findingDescriptorsByFindingTypeId.getValue(codeScopeName)).get(check)).getReferencedOptions();
                for (ConfigOptionDescriptorBase option : options) {
                    String configuredOptionValue = option.retrieveValueAsString(codeScopeName);
                    ((ArrayList)checkOptions.getValue(codeScopeName)).add(new AbapLintCheckOption(option.getName(), configuredOptionValue, option.getType()));
                }
            }
        }
        triggerBuilder.setTriggerParameter("check-options", ITriggerParameter.of(checkOptions));
        proxy.createTrigger(triggerBuilder);
        super.configureProjectInternal(proxy);
    }

    private static <T> @NonNull CodeScopeAware<ArrayList<T>> initializeWithEmptyLists(@NonNull List<CodeScopeName> codeScopeName) {
        CodeScopeAware lists = CodeScopeAware.empty();
        for (CodeScopeName codeScope : codeScopeName) {
            lists.setValue(codeScope, new ArrayList());
        }
        return lists;
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        this.autoExpose(template.getCodeScope());
        if (!tools.contains(EAnalysisTool.ABAPLINT) || !languages.contains(ELanguage.ABAP)) {
            return;
        }
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerGlobalOptionCodeScopeAware(this.getOptionForField("defaultLanguage", template.getCodeScope()));
        super.registerQualityIndicators(template, languages, tools);
    }

    public record AbapLintCheckOption(String optionName, String value, String type) {
    }
}

