/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.index.report.parser.sap_code_inspector.CodePalFindings;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.jetbrains.annotations.VisibleForTesting;

public class CodeInspectorConfiguration
extends ToolConfigurationBase {
    public static final String CATEGORY_NAME = "Code Inspector";
    private static final String DESCRIPTIONS_PATH = "code-inspector";
    private static final String CODE_PAL_DESCRIPTIONS_PATH = "code-pal";
    public static final String CHECK_MAPPINGS_TSV = "code-inspector/check-mappings.tsv";
    private static final String CODE_PAL_ENABLEMENT_NOTE = "### Enabling the check\nNote that enabling this item only enables the import of findings in Teamscale. To generate any findings, the ATC check must be independently enabled in the check variant.\n[documentation](./documentation/tutorial/sap-integration/#integrating-sap-code-inspector-atc)\n\nThis check is part of the \u201cCode Pal for ABAP\u201d collection of checks, which must be installed separately in the SAP system.\n";
    private static final String CVA_ENABLEMENT_NOTE = "### Enabling the check\nNote that enabling this item only enables the import of findings in Teamscale. To generate any findings, the ATC check must be independently enabled in the check variant.\n[documentation](./documentation/tutorial/sap-integration/#integrating-sap-code-inspector-atc)\n\nThis check is part of the SAP Code Vulnerability Analyzer (CVA), which requires a separate license from SAP.\n";
    private static final String STANDARD_ENABLEMENT_NOTE = "### Enabling the check\nNote that enabling this item only enables the import of findings in Teamscale. To generate any findings, the ATC check must be independently enabled in the check variant.\n[documentation](./documentation/tutorial/sap-integration/#integrating-sap-code-inspector-atc)\n";
    @VisibleForTesting
    public static final Set<String> KNOWN_CVA_FINDING_IDS = Set.of("EXTENDED_CHECK[0821](E)", "EXTENDED_CHECK[1101](E)", "EXTENDED_CHECK[1104](E)", "EXTENDED_CHECK[1106](E)", "EXTENDED_CHECK[1108](E)", "EXTENDED_CHECK[1109](E)", "EXTENDED_CHECK[110A](E)", "EXTENDED_CHECK[110B](E)", "EXTENDED_CHECK[1110](O)", "EXTENDED_CHECK[1110](E)", "EXTENDED_CHECK[1112](E)", "EXTENDED_CHECK[1114](E)", "EXTENDED_CHECK[1116](W)", "EXTENDED_CHECK[1116](E)", "EXTENDED_CHECK[1117](E)", "EXTENDED_CHECK[1117](W)", "EXTENDED_CHECK[1118](E)", "EXTENDED_CHECK[1120](E)", "EXTENDED_CHECK[1121](O)", "EXTENDED_CHECK[1121](E)", "EXTENDED_CHECK[1122](E)", "EXTENDED_CHECK[1124](E)", "EXTENDED_CHECK[1126](E)", "EXTENDED_CHECK[1128](E)", "EXTENDED_CHECK[1130](E)", "EXTENDED_CHECK[1132](O)", "EXTENDED_CHECK[1132](E)", "EXTENDED_CHECK[1134](O)", "EXTENDED_CHECK[1135](N)", "EXTENDED_CHECK[1140](N)", "EXTENDED_CHECK[1140](E)", "EXTENDED_CHECK[1141](E)", "EXTENDED_CHECK[1141](N)", "EXTENDED_CHECK[1142](E)", "EXTENDED_CHECK[1143](E)", "EXTENDED_CHECK[1144](E)", "EXTENDED_CHECK[114A](E)", "EXTENDED_CHECK[114A](O)", "EXTENDED_CHECK[114B](E)", "EXTENDED_CHECK[114B](O)", "EXTENDED_CHECK[114C](E)", "EXTENDED_CHECK[114C](O)", "EXTENDED_CHECK[114D](E)", "EXTENDED_CHECK[114D](O)", "EXTENDED_CHECK[114E](E)", "EXTENDED_CHECK[114F](E)", "EXTENDED_CHECK[114G](E)", "EXTENDED_CHECK[114H](O)", "EXTENDED_CHECK[1150](E)", "EXTENDED_CHECK[1150](W)", "EXTENDED_CHECK[1151](E)", "EXTENDED_CHECK[1151](O)", "EXTENDED_CHECK[1152](O)", "EXTENDED_CHECK[1152](E)", "EXTENDED_CHECK[1160](E)", "EXTENDED_CHECK[1161](E)", "EXTENDED_CHECK[1162](E)", "EXTENDED_CHECK[1163](N)", "EXTENDED_CHECK[1164](E)", "EXTENDED_CHECK[1165](E)", "EXTENDED_CHECK[1170](E)", "EXTENDED_CHECK[1171](O)", "EXTENDED_CHECK[1171](E)", "EXTENDED_CHECK[1180](E)", "EXTENDED_CHECK[1181](E)", "EXTENDED_CHECK[1190](E)", "EXTENDED_CHECK[11A1](N)", "EXTENDED_CHECK[11A1](O)", "EXTENDED_CHECK[11A2](N)", "EXTENDED_CHECK[11A2](O)", "EXTENDED_CHECK[11C1](E)", "EXTENDED_CHECK[11D1](E)", "EXTENDED_CHECK[11F1](O)", "EXTENDED_CHECK[11F1](E)", "EXTENDED_CHECK[11G0](W)", "EXTENDED_CHECK[11G1](W)", "EXTENDED_CHECK[11K1](E)", "EXTENDED_CHECK[11K2](E)", "EXTENDED_CHECK[11K3](E)", "EXTENDED_CHECK[11P1](E)", "EXTENDED_CHECK[11S1](E)", "EXTENDED_CHECK[11S2](E)", "EXTENDED_CHECK[11S3](E)", "EXTENDED_CHECK[11S4](E)", "EXTENDED_CHECK_SEC[NO_LICENSE](E)");

    public CodeInspectorConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.CODE_INSPECTOR, CATEGORY_NAME, DESCRIPTIONS_PATH, CHECK_MAPPINGS_TSV, "");
    }

    protected String getDescription(String ruleId, String descriptionPath) {
        if (CodePalFindings.KNOWN_CODE_PAL_FINDING_IDS.contains(ruleId)) {
            return super.getDescription(ruleId, descriptionPath + "/code-pal") + "\n\n### Enabling the check\nNote that enabling this item only enables the import of findings in Teamscale. To generate any findings, the ATC check must be independently enabled in the check variant.\n[documentation](./documentation/tutorial/sap-integration/#integrating-sap-code-inspector-atc)\n\nThis check is part of the \u201cCode Pal for ABAP\u201d collection of checks, which must be installed separately in the SAP system.\n";
        }
        if (KNOWN_CVA_FINDING_IDS.contains(ruleId)) {
            return CVA_ENABLEMENT_NOTE;
        }
        return STANDARD_ENABLEMENT_NOTE;
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains(EAnalysisTool.CODE_INSPECTOR)) {
            return;
        }
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }
}

