/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools.message;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import com.teamscale.index.configuration.tools.message.IMessageManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ExternalAnalysisToolMessageManager
implements IMessageManager {
    private Map<String, ExternalFindingsDescription> ruleIdToFindingsDescriptionName;
    private final EAnalysisTool tool;
    private static final Map<EAnalysisTool, ExternalAnalysisToolMessageManager> TOOL_TO_MESSAGE_MANAGER = new HashMap<EAnalysisTool, ExternalAnalysisToolMessageManager>();

    public ExternalAnalysisToolMessageManager(EAnalysisTool tool, List<ExternalFindingsDescription> descriptions) {
        this.tool = tool;
        this.ruleIdToFindingsDescriptionName = new HashMap<String, ExternalFindingsDescription>();
        for (ExternalFindingsDescription description : descriptions) {
            this.ruleIdToFindingsDescriptionName.put(description.getTypeId(), description);
        }
    }

    public String createFindingsGroupNameFor(ExternalFindingsDescription description) {
        CCSMAssert.isNotNull((Object)description, (String)"Unexpected findings description of value null.");
        if (this.tool == EAnalysisTool.CUSTOM) {
            return description.getName();
        }
        return description.getTypeId();
    }

    public static void initializeMessageManagerFor(EAnalysisTool tool, List<ExternalFindingsDescription> descriptions) {
        TOOL_TO_MESSAGE_MANAGER.put(tool, new ExternalAnalysisToolMessageManager(tool, descriptions));
    }

    public static ExternalAnalysisToolMessageManager getInstance(EAnalysisTool tool, List<ExternalFindingsDescription> descriptions) {
        if (!TOOL_TO_MESSAGE_MANAGER.containsKey(tool)) {
            ExternalAnalysisToolMessageManager.initializeMessageManagerFor(tool, descriptions);
        }
        return TOOL_TO_MESSAGE_MANAGER.get(tool);
    }

    @Override
    public String getFindingCategoryName() {
        return this.tool.getReadableName();
    }

    @Override
    public String getFindingsGroupNameFor(String ruleId) {
        return this.createFindingsGroupNameFor(this.ruleIdToFindingsDescriptionName.get(ruleId));
    }

    @Override
    public boolean hasRule(String ruleId) {
        return this.ruleIdToFindingsDescriptionName.get(ruleId) != null;
    }

    @Override
    public String getReadableNameFor(String ruleId) {
        return this.ruleIdToFindingsDescriptionName.get(ruleId).getName();
    }
}

