/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.EDirection;
import com.teamscale.index.dataflow.IDataFlowGraph;
import com.teamscale.index.dataflow.IDataflowAnalysis;
import com.teamscale.index.dataflow.IDataflowFindingsCreator;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.graph.EGraphvizOutputFormat;
import org.conqat.lib.commons.graph.GraphDebuggingUtils;
import org.conqat.lib.commons.graph.GraphvizException;
import org.conqat.lib.commons.graph.GraphvizGenerator;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.PerformanceMonitor;
import org.conqat.lib.commons.visitor.IMeshWalker;

public abstract class DataflowAnalysisBase<StateT, DataT, ResultT extends DataflowAnalysisResult<?, ?>>
implements IDataflowAnalysis {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_MAX_ANALYSIS_TIME = 600000;
    private static final int MAX_ITERATIONS = 200000;
    private final Map<ControlFlowNode, StateT> outStates = new HashMap<ControlFlowNode, StateT>();
    protected TokenElementInfo element;
    protected ControlFlowGraph controlFlowGraph;
    protected StringOffsetTransformer offsetTransformer;
    protected LineOffsetConverter rawLineOffsetConverter;
    private IDataFlowGraph dataFlowGraph;
    private static final String GENERATE_GRAPHVIZ = "DataflowAnalysis.GENERATE_GRAPHVIZ";

    protected void finalizeAnalysis(ControlFlowGraph cfg, ResultT result) throws StorageException {
    }

    @Override
    public ListMap<String, IndexFinding> analyze(TokenElementInfo element, ControlFlowGraph controlFlowGraph, List<IFalsePositiveFilter> filters, List<ShallowEntity> fileEntities, LineOffsetConverter rawLineOffsetConverter) throws ConQATException {
        this.element = element;
        this.rawLineOffsetConverter = rawLineOffsetConverter;
        this.offsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
        PerformanceMonitor performanceMonitor = PerformanceMonitor.create();
        Deque<WorkItem> workList = this.initializeAnalysis(controlFlowGraph);
        int i = 0;
        while (!workList.isEmpty()) {
            if (i > this.getMaxIterations() || performanceMonitor.getMilliseconds() > this.getMaxAnalysisTime()) {
                this.abortAnalysis(controlFlowGraph, this.outStates);
                this.statistics(i, performanceMonitor.stop(), false);
                LOGGER.warn("Dataflow analysis " + this.getClass().getSimpleName() + " took too many iterations for method " + controlFlowGraph.getMethodName() + " in element " + element.getUniformPath() + ". Aborting.");
                return new ListMap();
            }
            ++i;
            this.performIterationStep(workList);
        }
        ResultT result = this.getResult(controlFlowGraph, this.outStates);
        this.finalizeAnalysis(controlFlowGraph, result);
        IDataflowFindingsCreator<ResultT> creator = this.createFindingsCreator(filters);
        ListMap<String, IndexFinding> findings = creator.createFindings(element, result, fileEntities, this.offsetTransformer, rawLineOffsetConverter);
        this.statistics(i, performanceMonitor.stop(), true);
        if (Boolean.getBoolean(GENERATE_GRAPHVIZ)) {
            this.generateGraphviz(controlFlowGraph);
        }
        return findings;
    }

    protected abstract IDataFlowGraph createDataFlowGraph(ControlFlowGraph var1);

    protected void abortAnalysis(ControlFlowGraph cfg, Map<ControlFlowNode, StateT> outStates) throws StorageException {
    }

    protected void statistics(int iterations, long millis, boolean success) {
    }

    protected int getMaxIterations() {
        return 200000;
    }

    protected long getMaxAnalysisTime() {
        return 600000L;
    }

    private void performIterationStep(Deque<WorkItem> workList) throws ConQATException {
        Object transformationResult;
        WorkItem item = workList.pop();
        boolean firstVisit = false;
        if (!this.outStates.containsKey(item.node)) {
            this.outStates.put(item.node, this.getDefaultState(item.node));
            firstVisit = true;
        }
        if (!this.isFeasible(transformationResult = this.transform(item.node, item.input))) {
            return;
        }
        if (!this.addToOutState(transformationResult, this.outStates.get(item.node), item.node) && !firstVisit) {
            return;
        }
        for (ControlFlowNode successor : this.getDataflowSuccessors(item.node)) {
            workList.add(new WorkItem(this, successor, transformationResult));
        }
    }

    protected abstract boolean isFeasible(DataT var1);

    protected abstract boolean addToOutState(DataT var1, StateT var2, ControlFlowNode var3);

    protected Map<ControlFlowNode, StateT> computeInStates() {
        HashMap inStates = new HashMap();
        for (ControlFlowNode node : this.outStates.keySet()) {
            ArrayList<StateT> states = new ArrayList<StateT>();
            for (ControlFlowNode predecessor : this.getDataflowPredecessors(node)) {
                StateT state = this.outStates.get(predecessor);
                if (state == null) {
                    state = this.getDefaultState(node);
                }
                states.add(state);
            }
            inStates.put(node, this.join(states, node));
        }
        return inStates;
    }

    protected abstract IDataflowFindingsCreator<ResultT> createFindingsCreator(List<IFalsePositiveFilter> var1);

    protected Deque<WorkItem> initializeAnalysis(ControlFlowGraph cfg) throws ConQATException {
        this.outStates.clear();
        this.controlFlowGraph = cfg;
        this.dataFlowGraph = this.createDataFlowGraph(cfg);
        ArrayDeque<WorkItem> queue = new ArrayDeque<WorkItem>();
        queue.add(new WorkItem(this, this.getStartNode(), this.getStartingInput(cfg)));
        return queue;
    }

    protected abstract StateT getDefaultState(ControlFlowNode var1);

    protected abstract DataT getStartingInput(ControlFlowGraph var1);

    protected abstract EDirection getDirection();

    private UnmodifiableList<ControlFlowNode> getDataflowSuccessors(ControlFlowNode block) {
        if (this.getDirection() == EDirection.FORWARD) {
            return this.dataFlowGraph.getSuccessors(block);
        }
        return this.dataFlowGraph.getPredecessors(block);
    }

    private UnmodifiableList<ControlFlowNode> getDataflowPredecessors(ControlFlowNode block) {
        if (this.getDirection() == EDirection.FORWARD) {
            return this.dataFlowGraph.getPredecessors(block);
        }
        return this.dataFlowGraph.getSuccessors(block);
    }

    protected abstract StateT join(List<StateT> var1, ControlFlowNode var2);

    protected abstract DataT transform(ControlFlowNode var1, DataT var2) throws ConQATException;

    protected abstract ResultT getResult(ControlFlowGraph var1, Map<ControlFlowNode, StateT> var2);

    protected ControlFlowNode getStartNode() {
        if (this.getDirection() == EDirection.FORWARD) {
            return this.dataFlowGraph.getEntry();
        }
        return this.dataFlowGraph.getExit();
    }

    public TokenElementInfo getElement() {
        return this.element;
    }

    private void generateGraphviz(ControlFlowGraph controlFlowGraph) throws ConQATException {
        String graphInDotFormat = GraphDebuggingUtils.getDotString((Object)controlFlowGraph.getRoot(), ControlFlowNode::getId, (IMeshWalker[])new IMeshWalker[]{ControlFlowNode.LAMBDA_WALKER, this::getDataflowSuccessors});
        File pngFile = new File(StringUtils.replaceAll((String)controlFlowGraph.getMethodName(), (Pattern)Patterns.SINGLE_NON_WORD_CHARACTER, (String)"_") + "_analysisGraph.png");
        try {
            FileSystemUtils.ensureParentDirectoryExists((File)pngFile);
            new GraphvizGenerator().generateFile(graphInDotFormat, pngFile, EGraphvizOutputFormat.PNG);
            LOGGER.log(Level.INFO, "Generated GraphViz file to " + pngFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new ConQATException("Dot is not available or could not create output file. Ignoring.", (Throwable)e);
        }
        catch (GraphvizException e) {
            throw new ConQATException("Exception during Graphviz execution. Ignoring " + String.valueOf(pngFile), (Throwable)e);
        }
    }

    public class WorkItem {
        private final ControlFlowNode node;
        private final DataT input;

        public WorkItem(DataflowAnalysisBase this$0, ControlFlowNode node, DataT input) {
            this.node = node;
            this.input = input;
        }

        public DataT getInput() {
            return this.input;
        }

        public ControlFlowNode getNode() {
            return this.node;
        }
    }
}

