/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.index.configuration.DataflowAnalysisTransformationPatterns;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.util.tokens.TokenStreamTransformationPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jetbrains.annotations.VisibleForTesting;

public class DataflowConfigurationParameters {
    private final List<String> trivialValues = new ArrayList<String>();
    private final Set<String> identifierBasedFilters = new HashSet<String>();
    private final Set<String> nullSafeMethodsFilters = new HashSet<String>();
    private final List<String> tokenTransformations = new ArrayList<String>();
    private boolean reportUnusedStaticAndPrivateMethodParameters = false;
    private boolean ignoreProtectedMethods = false;
    private boolean ignoreAssignmentInDeclaration = false;
    private boolean ignoreMallocAssignments = false;

    public List<TokenStreamTransformationPattern> buildTokenTransformations() throws ConQATException {
        ArrayList<TokenStreamTransformationPattern> result = new ArrayList<TokenStreamTransformationPattern>();
        for (String transformation : this.tokenTransformations) {
            result.add(DataflowAnalysisTransformationPatterns.createPatternFromString(transformation));
        }
        return result;
    }

    @VisibleForTesting
    public void addTokenTransformation(ELanguage language, String searchPattern, String replacementPattern) {
        this.tokenTransformations.add(DataflowAnalysisTransformationPatterns.getStringRepresentationForTokenTransformation(language, searchPattern, replacementPattern));
    }

    public boolean shouldReportUnusedStaticAndPrivateMethodParameters() {
        return this.reportUnusedStaticAndPrivateMethodParameters;
    }

    public boolean isIgnoreProtectedMethods() {
        return this.ignoreProtectedMethods;
    }

    public boolean isIgnoreAssignmentInDeclaration() {
        return this.ignoreAssignmentInDeclaration;
    }

    public boolean isIgnoreMallocAssignments() {
        return this.ignoreMallocAssignments;
    }

    public void setIgnoreAssignmentInDeclaration(boolean ignoreAssignmentInDeclaration) {
        this.ignoreAssignmentInDeclaration = ignoreAssignmentInDeclaration;
    }

    public void setReportUnusedStaticAndPrivateMethodParameters(boolean reportUnusedStaticAndPrivateMethodParameters) {
        this.reportUnusedStaticAndPrivateMethodParameters = reportUnusedStaticAndPrivateMethodParameters;
    }

    public void setIgnoreMallocAssignments(boolean ignoreMallocAssignments) {
        this.ignoreMallocAssignments = ignoreMallocAssignments;
    }

    public List<String> getTrivialValues() {
        return this.trivialValues;
    }

    public UnmodifiableSet<String> getIdentifierBasedFilters() {
        return CollectionUtils.asUnmodifiable(this.identifierBasedFilters);
    }

    public UnmodifiableSet<String> getNullSafeMethodsFilters() {
        return CollectionUtils.asUnmodifiable(this.nullSafeMethodsFilters);
    }

    public void addIdentifierBasedFilters(Collection<String> identifierBasedFilters) {
        this.identifierBasedFilters.addAll(identifierBasedFilters);
    }

    public void addNullSafeMethodFilters(Collection<String> nullSafeMethodNames) {
        this.nullSafeMethodsFilters.addAll(nullSafeMethodNames);
    }

    public void addTrivialValues(Collection<String> values) {
        this.trivialValues.addAll(values);
    }

    public void addTokenTransformations(List<String> tokenTransformations) {
        this.tokenTransformations.addAll(tokenTransformations);
    }

    public void setIgnoreProtectedMethods(boolean ignoreProtectedMethods) {
        this.ignoreProtectedMethods = ignoreProtectedMethods;
    }
}

