/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.cs;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cs.CsDefUseHeuristic;
import com.teamscale.index.dataflow.filters.FalsePositiveFilterUtils;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.List;
import java.util.Optional;

public class OutRefParameterDeadStoreFilter
implements IFalsePositiveFilter {
    private static final TokenPattern OUT_PARAMETER_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.OUT}).alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0), new TokenPattern().alternative(new Object[]{ETokenType.STRING, LanguageFeatureParser.CS.primitiveTypeToken(), ETokenType.VAR}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0), new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0), new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).skipTo(new Object[]{ETokenType.RPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0)}).notFollowedBy(CsDefUseHeuristic.DEREFERENCE_OPERATORS);
    private static final TokenPattern REF_PARAMETER_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.REF}).optional(new Object[]{LanguageFeatureParser.CS.primitiveTypeToken()}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0).notFollowedBy(CsDefUseHeuristic.DEREFERENCE_OPERATORS);

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph cfg, List<ShallowEntity> fileEntities, TokenElementInfo node) {
        return OutRefParameterDeadStoreFilter.isRefOrOutParameterInMethodCall(variable, statement) || OutRefParameterDeadStoreFilter.isOutParameterInMethodDefinition(variable, cfg);
    }

    private static boolean isRefOrOutParameterInMethodCall(String variable, ControlFlowNode statement) {
        List<IToken> tokens = statement.getTokens();
        if (!OutRefParameterDeadStoreFilter.isPassedAsMethodParameter(tokens, variable)) {
            return false;
        }
        if (OutRefParameterDeadStoreFilter.isRefParameter(tokens, variable)) {
            return true;
        }
        return OutRefParameterDeadStoreFilter.isOutParameter(tokens, variable) && OutRefParameterDeadStoreFilter.isOutParameterUsedInStatementAfterward(tokens, variable);
    }

    private static boolean isPassedAsMethodParameter(List<IToken> tokens, String variable) {
        for (Integer index : TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN})) {
            List methodParameters = TokenStreamUtils.tokensBetweenWithNesting(tokens, (int)(index + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            Optional<IToken> parameter = methodParameters.stream().filter(token -> token.getText().equals(variable)).findFirst();
            if (!parameter.isPresent()) continue;
            return true;
        }
        return false;
    }

    private static boolean isRefParameter(List<IToken> tokens, String variable) {
        for (TokenPatternMatch match : REF_PARAMETER_PATTERN.findAll(tokens)) {
            if (!match.groupString(0).equals(variable)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isOutParameter(List<IToken> tokens, String variable) {
        for (TokenPatternMatch match : OUT_PARAMETER_PATTERN.findAll(tokens)) {
            if (!match.groupString(0).equals(variable)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOutParameterInMethodDefinition(String variable, ControlFlowGraph cfg) {
        ControlFlowNode parameterControlFlowNode = cfg.getRoot();
        for (VariableWrite assignment : parameterControlFlowNode.getReadWriteInfo().getAllWrites()) {
            if (!assignment.isDefaultInitialization() && !OutRefParameterDeadStoreFilter.isOutParameter(parameterControlFlowNode.getTokens(), variable) || !assignment.getChangedVariable().equals(variable)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOutParameterUsedInStatementAfterward(List<IToken> tokens, String variable) {
        IToken variableToken = tokens.stream().filter(token -> token.getText().equals(variable)).findFirst().get();
        return FalsePositiveFilterUtils.isVariableUsedInStatementAfterward(tokens, variable, tokens.indexOf(variableToken));
    }
}

