/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallValueReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class MethodCallInputValueReference
extends MethodCallValueReferenceBase {
    private static final long serialVersionUID = 1L;
    private static final String MCI_REFERENCE_NAME_PREFIX = "MCI_";
    private final EInputParameterType inputValueType;
    private boolean isCalleeUnknown;

    public MethodCallInputValueReference(MethodCallReference methodCall, EInputParameterType inputValueType, String parameterId, ElementLocation location, String referenceContainerMethodId) {
        super(MethodCallInputValueReference.buildReferenceName(MCI_REFERENCE_NAME_PREFIX, methodCall, inputValueType.toString(), parameterId), location, methodCall, parameterId, referenceContainerMethodId);
        this.inputValueType = inputValueType;
        if (inputValueType == EInputParameterType.UNNAMED) {
            CCSMAssert.isTrue((boolean)StringUtils.isInteger((String)parameterId), (String)"expected integer as index for unnamed parameter");
        }
    }

    @Override
    public TaintGraphReferenceBase.EReferenceType getType() {
        return TaintGraphReferenceBase.EReferenceType.METHOD_CALL_INPUT;
    }

    public String toString() {
        return super.getReferenceName();
    }

    @Override
    public TaintGraphReferenceBase cloneWithNewSSA(String newSSA, ElementLocation location) {
        throw new UnsupportedOperationException("Should not overwrite methodCallInputValues (No SSA needed).");
    }

    public MethodCallReference getMethodCallReference() {
        return this.methodCall;
    }

    @Override
    public String toFindingDescription() {
        Object description = "";
        switch (this.getInputValueType().ordinal()) {
            case 2: {
                description = "Possibly tainted field `" + this.getParameterId() + "` can be modified in method call";
                break;
            }
            case 1: {
                description = "Possibly tainted parameter `" + this.getParameterId() + "` can be modified in method call";
                break;
            }
            case 0: {
                description = "Possibly tainted parameter at index " + this.getParameterId() + " can be modified in method call";
                break;
            }
            default: {
                CCSMAssert.fail((String)("EInputParameterType " + String.valueOf((Object)this.getInputValueType()) + " not handled in switch"));
            }
        }
        if (this.isCalleeUnknown) {
            description = (String)description + ". Callee could not be resolved.";
        }
        return description;
    }

    public EInputParameterType getInputValueType() {
        return this.inputValueType;
    }

    public void setCalleeUnknown(boolean isUnknown) {
        this.isCalleeUnknown = isUnknown;
    }

    @IndexValueClass
    public static enum EInputParameterType {
        UNNAMED,
        NAMED,
        FIELD;

    }
}

