/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;

@Index(name="unresolved-dependencies", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED})
public class UnresolvedDependenciesIndex
implements IProjectIndex {
    private final ValueIndex<ArrayList<String>> delegateIndex;
    private static final String PATH_KEY_PREFIX = "path:";
    private static final String TYPE_KEY_PREFIX = "type:";

    public UnresolvedDependenciesIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    public void removePaths(Collection<String> paths) throws StorageException {
        List<String> pathKeys = UnresolvedDependenciesIndex.createPathKeys(paths);
        ArrayList<String> keysToDelete = new ArrayList<String>(pathKeys);
        ArrayList<String> typesToUpdate = new ArrayList<String>(this.getTypesForPaths(paths));
        List values = this.delegateIndex.getValues(UnresolvedDependenciesIndex.createTypeKeys(typesToUpdate));
        PairList valuesToWrite = new PairList();
        for (int i = 0; i < typesToUpdate.size(); ++i) {
            String type = (String)typesToUpdate.get(i);
            if (values.get(i) == null) continue;
            ArrayList newValues = new ArrayList((Collection)values.get(i));
            newValues.removeAll(paths);
            if (newValues.isEmpty()) {
                keysToDelete.add(UnresolvedDependenciesIndex.createTypeKey(type));
                continue;
            }
            valuesToWrite.add((Object)UnresolvedDependenciesIndex.createTypeKey(type), newValues);
        }
        this.delegateIndex.removeValues(keysToDelete);
        this.delegateIndex.setValues(valuesToWrite);
    }

    public void setUnresolvedDependencies(PairList<String, ArrayList<String>> pathsWithUnresolvedTypes) throws StorageException {
        HashSet pathsToUpdate = new HashSet(pathsWithUnresolvedTypes.extractFirstList());
        List typeLists = this.delegateIndex.getValues(UnresolvedDependenciesIndex.createPathKeys(pathsWithUnresolvedTypes.extractFirstList()));
        List<String> types = typeLists.stream().filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        List pathLists = this.delegateIndex.getValues(UnresolvedDependenciesIndex.createTypeKeys(types));
        SetMap typeToPaths = new SetMap();
        for (int i = 0; i < types.size(); ++i) {
            List paths = (List)pathLists.get(i);
            if (paths == null) continue;
            paths.removeAll(pathsToUpdate);
            typeToPaths.addAll((Object)types.get(i), (Collection)paths);
        }
        PairList valuesToWrite = new PairList();
        for (int i = 0; i < pathsWithUnresolvedTypes.size(); ++i) {
            String path = (String)pathsWithUnresolvedTypes.getFirst(i);
            for (String type : (ArrayList)pathsWithUnresolvedTypes.getSecond(i)) {
                typeToPaths.add((Object)type, (Object)path);
            }
            valuesToWrite.add((Object)UnresolvedDependenciesIndex.createPathKey(path), (Object)((ArrayList)pathsWithUnresolvedTypes.getSecond(i)));
        }
        for (String type : typeToPaths.getKeys()) {
            valuesToWrite.add((Object)UnresolvedDependenciesIndex.createTypeKey(type), new ArrayList(typeToPaths.getCollectionOrEmpty((Object)type)));
        }
        this.delegateIndex.setValues(valuesToWrite);
    }

    private static String createPathKey(String path) {
        return PATH_KEY_PREFIX + path;
    }

    private static String createTypeKey(String type) {
        return TYPE_KEY_PREFIX + type;
    }

    private static List<String> createPathKeys(Collection<String> paths) {
        return CollectionUtils.map(paths, UnresolvedDependenciesIndex::createPathKey);
    }

    private static List<String> createTypeKeys(Collection<String> types) {
        return CollectionUtils.map(types, UnresolvedDependenciesIndex::createTypeKey);
    }

    public Set<String> getPathsForTypes(Collection<String> types) throws StorageException {
        return this.delegateIndex.getValues(UnresolvedDependenciesIndex.createTypeKeys(types)).stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> getTypesForPaths(Collection<String> paths) throws StorageException {
        return this.delegateIndex.getValues(UnresolvedDependenciesIndex.createPathKeys(paths)).stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String debugStringRepresentation() throws StorageException {
        return this.delegateIndex.getAllEntries().toString();
    }
}

