/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="external.report.archive", name="External Upload Report Archival", type=EOptionType.SERVER, category=EOptionCategory.LIMITS)
@IndexValueClass(containedInBackup=true)
public class ExternalUploadReportArchiveOption
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "external.report.archive";
    public static final String OPTION_NAME = "External Upload Report Archival";
    private static final String DEFAULT_MAX_REPORT_ARCHIVE_INDEX_SIZE = "3 GB";
    @JsonProperty(value="maxReportArchiveIndexSize")
    @OptionFieldDescription(name="Maximum accumulated size of all archived reports", description="The size can be given with a unit [B, KB, KiB, MB, MiB, GB, GiB]. A size without unit is interpreted as bytes. When the size of the stored reports becomes bigger than this, older reports are removed automatically. Set to 0 to disable report archival completely.")
    public String maxReportArchiveIndexSize = "3 GB";

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        try {
            if (FileSystemUtils.parseDataSize((String)this.maxReportArchiveIndexSize) < 0L) {
                return "Maximum report archive size must not be negative.";
            }
        }
        catch (NumberFormatException e) {
            return "Maximum report archive size is not a valid size.";
        }
        return null;
    }

    public static long getMaxReportArchiveIndexSize(ServerOptionIndex serverOptionIndex) throws StorageException {
        ExternalUploadReportArchiveOption reportArchiveOption = (ExternalUploadReportArchiveOption)ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, ExternalUploadReportArchiveOption.class, serverOptionIndex);
        if (reportArchiveOption == null) {
            return FileSystemUtils.parseDataSize((String)DEFAULT_MAX_REPORT_ARCHIVE_INDEX_SIZE);
        }
        return FileSystemUtils.parseDataSize((String)reportArchiveOption.maxReportArchiveIndexSize);
    }
}

