/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.fileloaders;

import com.teamscale.commons.annotation.ClassIndexUtils;
import com.teamscale.index.fileloaders.FileLoader;
import com.teamscale.index.fileloaders.IFileLoader;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class FileLoaderRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FileLoaderRegistry INSTANCE = new FileLoaderRegistry();
    private final Map<String, Class<? extends IFileLoader>> fileLoaders = new HashMap<String, Class<? extends IFileLoader>>();

    private FileLoaderRegistry() {
        List fileLoaderClasses = ClassIndexUtils.getAnnotated(FileLoader.class);
        for (Class fileLoaderClass : fileLoaderClasses) {
            if (IFileLoader.class.isAssignableFrom(fileLoaderClass)) {
                FileLoader fileLoaderAnnotation = fileLoaderClass.getAnnotation(FileLoader.class);
                this.registerFileLoader(fileLoaderAnnotation.extension(), fileLoaderClass.asSubclass(IFileLoader.class));
                continue;
            }
            LOGGER.error("Expecting " + String.valueOf(fileLoaderClass) + " to implement " + String.valueOf(IFileLoader.class));
        }
    }

    public static FileLoaderRegistry getInstance() {
        return INSTANCE;
    }

    private void registerFileLoader(String extension, Class<? extends IFileLoader> loaderClass) {
        if (this.fileLoaders.containsKey(extension = extension.toLowerCase())) {
            CCSMAssert.fail((String)("Another file loader has been registered for extension '" + extension + "':" + this.fileLoaders.get(extension).getName()));
        }
        this.fileLoaders.put(extension, loaderClass);
    }

    private Class<? extends IFileLoader> getFileLoader(String extension) {
        return this.fileLoaders.get(extension.toLowerCase());
    }

    public IFileLoader getFileLoader(File file, Logger logger) throws ReflectiveOperationException {
        try {
            String fileExtension = FileSystemUtils.getFileExtension((File)file);
            Class<? extends IFileLoader> loaderClass = this.getFileLoader(Objects.requireNonNull(fileExtension));
            if (loaderClass != null) {
                return loaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("Could not instantiate loader.", (Throwable)e);
        }
        logger.error("Could not find a loader for file: " + String.valueOf(file));
        return null;
    }
}

