/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis.execution_server;

import com.teamscale.index.findings.clangtidy.outsourced_analysis.ClangTidyOutsourcedAnalysisHashUtils;
import com.teamscale.index.resource.BasicTokenElementIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public final class ClangTidyOutsourcedAnalysisLocalContentReader {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Map<String, BasicTokenElementInfo> loadLocalBasicTokenElements(@Nullable UnresolvedCommitDescriptor commit, Map<String, String> fileContentHashes, BasicTokenElementIndex basicTokenElementIndex) throws StorageException {
        int missingFiles;
        HashMap<String, BasicTokenElementInfo> basicTokenElements = new HashMap<String, BasicTokenElementInfo>();
        Map<String, BasicTokenElementInfo> elements = basicTokenElementIndex.getTokenElementsByPath(fileContentHashes.keySet());
        for (Map.Entry<String, String> fileInfo : fileContentHashes.entrySet()) {
            BasicTokenElementInfo elementOnExecutionServer;
            String uniformPath = fileInfo.getKey();
            String contentHash = fileInfo.getValue();
            if (contentHash.equals(ClangTidyOutsourcedAnalysisHashUtils.generateClangTidyFileContentHash(elementOnExecutionServer = elements.get(uniformPath)))) {
                basicTokenElements.put(elementOnExecutionServer.getUniformPath(), elementOnExecutionServer);
                continue;
            }
            LOGGER.debug("Content will not be used for analysis: Found '{}' reading at {}, but hashes did not match.", (Object)uniformPath, (Object)HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        }
        if (!basicTokenElements.isEmpty()) {
            LOGGER.debug("Found local content for {} file(s) at {}.", (Object)basicTokenElements.size(), (Object)HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        }
        if ((missingFiles = fileContentHashes.size() - basicTokenElements.size()) > 0) {
            LOGGER.error("Missing local content at {} for file(s): {}", (Object)HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()), (Object)fileContentHashes.entrySet().stream().filter(Predicate.not(entry -> basicTokenElements.containsKey(entry.getKey()))).map(Map.Entry::getKey).map(StringUtils::surroundWithSingleQuotes).collect(Collectors.joining(", ")));
        }
        return basicTokenElements;
    }
}

