/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.swiftlint;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;

public class SwiftLintOutputParser {
    public static final String FINDING_CATEGORY = "swiftlint";
    private static final Logger LOGGER = LogManager.getLogger();
    private final PathLookupIndex pathLookupIndex;
    private final Map<String, LineOffsetConverter> uniformPathToConverter = new HashMap<String, LineOffsetConverter>();
    private final Map<String, TokenElementInfo> uniformPathToElement;

    public SwiftLintOutputParser(PathLookupIndex pathLookupIndex, Map<String, TokenElementInfo> uniformPathToElement) {
        this.pathLookupIndex = pathLookupIndex;
        this.uniformPathToElement = uniformPathToElement;
    }

    public ListMap<String, IndexFinding> parseOutput(String swiftLintOutput) {
        String[] lines;
        ListMap findings = new ListMap();
        if (StringUtils.isEmpty((String)swiftLintOutput)) {
            LOGGER.info("SwiftLint output was empty");
            return findings;
        }
        for (String line : lines = StringUtils.splitLines((String)swiftLintOutput)) {
            this.processLine((ListMap<String, IndexFinding>)findings, line);
        }
        return findings;
    }

    private void processLine(ListMap<String, IndexFinding> findings, String line) {
        List splittedLine = StringUtils.splitWithEscapeCharacter((String)line, (Character)Character.valueOf(':'));
        if (splittedLine.size() < 6) {
            LOGGER.error("Unexpected SwiftLint result format: " + line);
            return;
        }
        String file = (String)splittedLine.get(0);
        Optional<String> uniformPath = this.pathLookupIndex.lookupBestPath(file, PathLookupOptions.defaults());
        if (uniformPath.isEmpty()) {
            LOGGER.warn("No uniform path for file found: " + file);
            return;
        }
        int fifthColonIndex = StringUtils.indexOfNthOccurrence((String)line, (char)':', (int)5);
        String messageSegment = line.substring(fifthColonIndex + 1).trim();
        int openParenIndex = messageSegment.lastIndexOf(40);
        if (openParenIndex == -1) {
            LOGGER.error("Unexpected SwiftLint message format: " + line);
            return;
        }
        String message = messageSegment.substring(0, openParenIndex - 1).trim();
        String rule = messageSegment.substring(openParenIndex + 1, messageSegment.length() - 1);
        int lineNumber = Integer.parseInt((String)splittedLine.get(1));
        ETrafficLightColor severity = SwiftLintOutputParser.parseTrafficLightColor(((String)splittedLine.get(3)).trim());
        IndexFinding finding = this.createFinding(uniformPath.get(), lineNumber, message, rule, severity);
        if (finding != null) {
            findings.add((Object)uniformPath.get(), (Object)finding);
        }
    }

    private static ETrafficLightColor parseTrafficLightColor(String color) {
        if ("error".equals(color)) {
            return ETrafficLightColor.RED;
        }
        return ETrafficLightColor.YELLOW;
    }

    private IndexFinding createFinding(String uniformPath, int lineNumber, String message, String rule, ETrafficLightColor trafficLightColor) {
        TokenElementInfo tokenElement = this.uniformPathToElement.get(uniformPath);
        if (tokenElement == null) {
            LOGGER.error("No token element found in SwiftLint working set for path: " + uniformPath);
            LOGGER.info("SwiftLint working set was: " + String.valueOf(this.uniformPathToElement.keySet()));
            LOGGER.error("Skipping finding '" + message + "' in line " + lineNumber + " for rule '" + rule + "'");
            return null;
        }
        LineOffsetConverter converter = this.uniformPathToConverter.computeIfAbsent(uniformPath, path -> new LineOffsetConverter(tokenElement.getText()));
        int rawStartOffset = converter.getOffset(lineNumber);
        int rawEndOffset = converter.getOffset(lineNumber + 1) - 1;
        TextRegionLocation textRegionLocation = new TextRegionLocation(uniformPath, rawStartOffset, rawEndOffset, lineNumber, lineNumber);
        IndexFinding indexFinding = new IndexFinding(rule, FINDING_CATEGORY, message, (ElementLocation)textRegionLocation);
        indexFinding.setAssessment(trafficLightColor);
        IndexFindingUtils.setGuidelineMapping((IndexFinding)indexFinding, (String)rule, (Set)EAnalysisTool.SWIFT_LINT.getSupportedLanguages());
        return indexFinding;
    }
}

