/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.issues.IssueUnmanagedKeysHistoryIndex;
import com.teamscale.index.issues.PathIssueIndex;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class IssueUnmanagedKeysSynchronizer
extends ChangeProcessorAnalysisStep {
    @DeltaSource(value=PathIssueIndex.class)
    private PathIssueIndex.Delta affectedFilesDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PathIssueIndex pathToIssueIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private IssueUnmanagedKeysHistoryIndex issueUnmanagedKeysHistoryIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;

    public void execute() throws Exception {
        HashMap<String, Set<UniformPath>> updatedEntries = new HashMap<String, Set<UniformPath>>();
        for (TeamscaleIssueId changedIssue : this.affectedFilesDelta.changedIssues()) {
            List<UniformPath> uniformPaths = this.pathToIssueIndex.getReferencedPaths(changedIssue);
            Set<UniformPath> existingPaths = this.getExistingPaths(uniformPaths);
            updatedEntries.put(changedIssue.getInternalId(), existingPaths);
        }
        this.issueUnmanagedKeysHistoryIndex.updateEntries(updatedEntries, this.getSchedulingCommit().getTimestamp(), Collections.emptySet());
    }

    private Set<UniformPath> getExistingPaths(List<UniformPath> uniformPaths) throws StorageException {
        return StreamSupport.stream(CollectionUtils.zip(uniformPaths, this.basicTokenElementIndex.getTokenElementsFor(uniformPaths)).spliterator(), false).filter(e -> e.getSecond() != null).map(ImmutablePair::getFirst).collect(Collectors.toSet());
    }
}

