/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.codebeamer.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.issues.codebeamer.client.model.Association;
import com.teamscale.index.issues.codebeamer.client.model.EDescriptionFormat;
import com.teamscale.index.issues.codebeamer.client.model.Label;
import com.teamscale.index.issues.codebeamer.client.model.field_values.AbstractFieldValue;
import com.teamscale.index.issues.codebeamer.client.model.field_values.TableFieldValue;
import com.teamscale.index.issues.codebeamer.client.model.references.AbstractReference;
import com.teamscale.index.issues.codebeamer.client.model.references.CommentReference;
import com.teamscale.index.issues.codebeamer.client.model.references.TrackerItemReference;
import com.teamscale.index.issues.codebeamer.client.model.references.TrackerReference;
import com.teamscale.index.issues.codebeamer.client.model.references.UserReference;
import com.teamscale.index.requirements_tracing.tools.util.WorkItemUtils;
import com.teamscale.wia.ManualTestCase;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class TrackerItem {
    @JsonProperty(value="accruedMillis")
    int accruedMillis;
    @JsonProperty(value="areas")
    List<AbstractReference> areas;
    @JsonProperty(value="assignedAt")
    String assignedAt;
    @JsonProperty(value="assignedTo")
    List<AbstractReference> assignedTo;
    @JsonProperty(value="categories")
    List<AbstractReference> categories;
    @JsonProperty(value="children")
    List<TrackerItemReference> children;
    @JsonProperty(value="closedAt")
    String closedAt;
    @JsonProperty(value="comments")
    List<CommentReference> comments;
    @JsonProperty(value="createdAt")
    String createdAt;
    @JsonProperty(value="createdBy")
    UserReference createdBy;
    @JsonProperty(value="customFields")
    List<AbstractFieldValue> customFields;
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="descriptionFormat")
    EDescriptionFormat descriptionFormat;
    @JsonProperty(value="endDate")
    String endDate;
    @JsonProperty(value="estimatedMillis")
    String estimatedMillis;
    @JsonProperty(value="formality")
    AbstractReference formality;
    @JsonProperty(value="id")
    int id;
    @JsonProperty(value="modifiedAt")
    String modifiedAt;
    @JsonProperty(value="modifiedBy")
    UserReference modifiedBy;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="ordinal")
    int ordinal;
    @JsonProperty(value="owners")
    List<AbstractReference> owners;
    @JsonProperty(value="parent")
    TrackerItemReference parent;
    @JsonProperty(value="platforms")
    List<TrackerItemReference> platforms;
    @JsonProperty(value="priority")
    AbstractReference priority;
    @JsonProperty(value="releaseMethod")
    AbstractReference releaseMethod;
    @JsonProperty(value="resolutions")
    List<AbstractReference> resolutions;
    @JsonProperty(value="severities")
    List<AbstractReference> severities;
    @JsonProperty(value="spentMillis")
    int spentMillis;
    @JsonProperty(value="startDate")
    String startDate;
    @JsonProperty(value="status")
    AbstractReference status;
    @JsonProperty(value="storyPoints")
    int storyPoints;
    @JsonProperty(value="subjects")
    List<AbstractReference> subjects;
    @JsonProperty(value="tags")
    List<Label> tags;
    @JsonProperty(value="teams")
    List<AbstractReference> teams;
    @JsonProperty(value="tracker")
    TrackerReference tracker;
    @JsonProperty(value="typeName")
    String typeName;
    @JsonProperty(value="version")
    int version;
    @JsonProperty(value="versions")
    List<AbstractReference> versions;
    private Map<String, AbstractFieldValue> fields = new HashMap<String, AbstractFieldValue>();

    public String getTypeName() {
        return this.typeName;
    }

    public static TrackerItemReference toTrackerItemReference(TrackerItem trackerItem) {
        return new TrackerItemReference(trackerItem.id);
    }

    private TeamscaleIssue toTeamscaleIssue(String connectorId, String codebeamerInstanceUrl, long startTimestamp, ZoneId zone) {
        PairList customFields = PairList.fromMap(this.fields).filter((key, value) -> value != null && value.getValue() != null);
        return new TeamscaleIssue(new TeamscaleIssueId(connectorId, Integer.toString(this.id)), this.name, this.getAssignee(), this.getAuthor(), this.description, this.getCreatedAt(zone), Math.max(this.getUpdatedAt(zone), startTimestamp), this.getStatus(), this.isClosed(), this.getIssueUrl(codebeamerInstanceUrl), customFields.extractFirstList(), customFields.extractSecondList().stream().map(AbstractFieldValue::getValue).toList(), this.getParentId());
    }

    public SpecItem toSpecItem(String connectorId, String codebeamerInstanceUrl, List<Association> associations, Map<String, String> typeAbbreviations, Map<String, String> typeNameMapping, long startTimestamp, ZoneId timezone) {
        ListMap<String, String> relationNameToRelatedItems = this.getRelationNamesToRelatedItems(associations);
        PairList pairList = (PairList)relationNameToRelatedItems.entrySet().stream().collect(PairList.toPairList(Map.Entry::getKey, Map.Entry::getValue));
        String resolvedTypeName = this.resolveTypename(typeNameMapping);
        String typeAbbreviation = typeAbbreviations.getOrDefault(resolvedTypeName, WorkItemUtils.generateWorkItemNameAbbreviation(resolvedTypeName));
        return new SpecItem(this.toTeamscaleIssue(connectorId, codebeamerInstanceUrl, startTimestamp, timezone), this.getAdditionalAssignees(), this.getAdditionalParents(), pairList.extractFirstList(), pairList.extractSecondList(), resolvedTypeName, typeAbbreviation);
    }

    private ListMap<String, String> getRelationNamesToRelatedItems(List<Association> associations) {
        ListMap relationNamesToRelatedItems = new ListMap();
        for (Association association : associations) {
            int relatedId = association.to().getId() == this.id ? association.from().getId() : association.to().getId();
            String relationName = Optional.ofNullable(association.type().getName()).orElse(association.type().getType()).toLowerCase();
            relationNamesToRelatedItems.add((Object)relationName, (Object)String.valueOf(relatedId));
        }
        return relationNamesToRelatedItems;
    }

    private String resolveTypename(Map<String, String> typeNameMapping) {
        return typeNameMapping.getOrDefault(this.tracker.getName(), this.typeName);
    }

    private List<String> getAdditionalParents() {
        return Collections.emptyList();
    }

    private List<String> getAdditionalAssignees() {
        if (this.assignedTo == null || this.assignedTo.size() < 2) {
            return Collections.emptyList();
        }
        return this.assignedTo.subList(1, this.assignedTo.size()).stream().map(AbstractReference::getName).toList();
    }

    private String getIssueUrl(String codebeamerInstanceUrl) {
        return StringUtils.ensureEndsWith((String)codebeamerInstanceUrl, (String)"/") + "issue/" + this.id;
    }

    private boolean isClosed() {
        return "Closed".equals(this.getStatus());
    }

    private String getStatus() {
        return this.status.getName();
    }

    private String getParentId() {
        if (this.parent == null) {
            return null;
        }
        return String.valueOf(this.parent.getId());
    }

    private String getAssignee() {
        if (this.assignedTo == null || this.assignedTo.isEmpty()) {
            return "";
        }
        return this.assignedTo.get(0).getName();
    }

    private String getAuthor() {
        return this.createdBy.getName();
    }

    private static long getTimestamp(String timestamp, ZoneId zone) {
        return LocalDateTime.parse(timestamp).atZone(zone).toInstant().toEpochMilli();
    }

    private long getCreatedAt(ZoneId zone) {
        return TrackerItem.getTimestamp(this.createdAt, zone);
    }

    private long getUpdatedAt(ZoneId zone) {
        return TrackerItem.getTimestamp(this.modifiedAt, zone);
    }

    public Map<String, AbstractFieldValue> getFields() {
        return this.fields;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EDescriptionFormat getDescriptionFormat() {
        return this.descriptionFormat;
    }

    public TrackerReference getTracker() {
        return this.tracker;
    }

    public void setFields(Map<String, AbstractFieldValue> fields) {
        TrackerItem.removeRedundantFields(fields);
        this.fields = fields;
    }

    private static void removeRedundantFields(Map<String, AbstractFieldValue> fields) {
        String[] fieldNames;
        for (String fieldName : fieldNames = new String[]{"Parent", "Priority", "Summary", "Status", "Type", "Assigned to", "Story Points", "Release", "Planned Effort", "Spent Effort", "Description Format", "Children", "Description", "ID", "Tracker", "Resolution", "Assigned at", "Accrued Effort", "Submitted by", "Submitted at", "Modified by", "Modified at", "Action", "Critical", "Expected result"}) {
            fields.remove(fieldName);
        }
    }

    public ManualTestCase toManualTestCase(SpecItem specItem) {
        List<Object> testSteps;
        Optional<AbstractFieldValue> optionalTestSteps = this.customFields.stream().filter(customField -> customField.getName().equals("Test Steps")).findFirst();
        if (optionalTestSteps.isEmpty()) {
            testSteps = Collections.emptyList();
        } else {
            this.customFields.remove(optionalTestSteps.get());
            this.fields.remove("Test Steps");
            this.fields.remove("Action");
            this.fields.remove("Expected result");
            this.fields.remove("Critical");
            testSteps = TrackerItem.getTestSteps((TableFieldValue)optionalTestSteps.get());
        }
        return new ManualTestCase(specItem, testSteps);
    }

    private static List<ManualTestCase.TestStep> getTestSteps(TableFieldValue testSteps) {
        List<List<AbstractFieldValue>> tableRows = testSteps.getListOfTableRows();
        if (tableRows == null || tableRows.isEmpty()) {
            return Collections.emptyList();
        }
        return tableRows.stream().map(TrackerItem::createTestStep).filter(Objects::nonNull).toList();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ManualTestCase.TestStep createTestStep(List<AbstractFieldValue> testStep) {
        if (testStep == null || testStep.isEmpty()) {
            return null;
        }
        String action = testStep.get(0).getValue();
        String expectedResult = testStep.size() == 1 ? "" : testStep.get(1).getValue();
        return new ManualTestCase.TestStep(action, expectedResult);
    }

    public int getId() {
        return this.id;
    }
}

