/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;

public enum EMergeRequestUpdateTriggerSchedulingReason {
    FORCE_VOTE("Re-vote for merge request '%s'.", Pattern.compile("Re-vote for merge request '(.+)'\\.")),
    WEBHOOK_RECEIVED("Received web hook for merge request '%s'.", Pattern.compile("Received web hook for merge request '(.+)'\\.")),
    OTHER("", Pattern.compile(".*"));

    private final String template;
    private final Pattern pattern;

    static EMergeRequestUpdateTriggerSchedulingReason fromString(String reasonString) {
        return Arrays.stream(EMergeRequestUpdateTriggerSchedulingReason.values()).filter(reason -> reason.matches(reasonString)).findFirst().orElse(OTHER);
    }

    private EMergeRequestUpdateTriggerSchedulingReason(String template, Pattern pattern) {
        this.template = template;
        this.pattern = pattern;
    }

    public String format(long mergeRequestId) {
        return String.format(this.template, mergeRequestId);
    }

    private boolean matches(String reasonString) {
        if (StringUtils.isEmpty((String)reasonString)) {
            return false;
        }
        return this.pattern.matcher(reasonString).matches();
    }
}

