/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.cluster;

import com.teamscale.index.merge_request.comments.cluster.FindingCluster;
import com.teamscale.index.merge_request.comments.cluster.IFindingClusterStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CompositeFindingClusterStrategy
implements IFindingClusterStrategy {
    private final IFindingClusterStrategy[] findingClusterStrategies;

    public CompositeFindingClusterStrategy(IFindingClusterStrategy ... findingClusterStrategies) {
        this.findingClusterStrategies = findingClusterStrategies;
    }

    @Override
    public List<FindingCluster> getFindingClusters(UniformPath uniformPath, List<TrackedFinding> findings) throws StorageException {
        ArrayList<FindingCluster> findingClusters = new ArrayList<FindingCluster>();
        ArrayList<TrackedFinding> findingsToAggregate = new ArrayList<TrackedFinding>(findings);
        for (IFindingClusterStrategy findingClusterStrategy : this.findingClusterStrategies) {
            List<FindingCluster> newFindingClusters = findingClusterStrategy.getFindingClusters(uniformPath, (List<TrackedFinding>)CollectionUtils.asUnmodifiable(findingsToAggregate));
            Set clusteredFindingIds = newFindingClusters.stream().flatMap(findingCluster -> findingCluster.getFindings().stream()).collect(Collectors.toSet());
            findingsToAggregate.removeIf(clusteredFindingIds::contains);
            findingClusters.addAll(newFindingClusters);
        }
        return findingClusters;
    }
}

