/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.comments;

import com.google.common.collect.ImmutableMap;
import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.merge_request.comments.FindingUtils;
import com.teamscale.index.merge_request.comments.comments.FindingsForReviewComment;
import com.teamscale.index.merge_request.comments.comments.MultiFindingReviewCommentBase;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.markup.MarkupUtils;

public class IdenticalFindingTypeReviewComment
extends MultiFindingReviewCommentBase {
    private static final String DEFAULT_MESSAGE = "This file contains %d instances of: ";
    private static final String MISSING_INTERFACE_COMMENTS_MESSAGE = "In this file %d interface comments are missing. Consider adding explanatory comments or restricting the visibility.";
    private static final String PUBLIC_ATTRIBUTES_MESSAGE = "This file has %d public attributes, which can be an indicator for poor encapsulation. You could resolve this by using getters and setters or by restricting the visibility, if possible.";
    private static final int FINDINGS_PER_COMMENT_LIMIT = 10;
    public static final Map<String, String> TYPE_IDS_TO_INTRODUCTION_MESSAGE_MAP = ImmutableMap.of((Object)IndexFinding.makeFindingTypeId((String)"Comments", (String)"Missing Interface Comment"), (Object)"In this file %d interface comments are missing. Consider adding explanatory comments or restricting the visibility.", (Object)IndexFinding.makeFindingTypeId((String)"Bad Practice", (String)"Public class attribute"), (Object)"This file has %d public attributes, which can be an indicator for poor encapsulation. You could resolve this by using getters and setters or by restricting the visibility, if possible.", (Object)IndexFinding.makeFindingTypeId((String)"Design Flaws", (String)"Public class attribute (C++)"), (Object)"This file has %d public attributes, which can be an indicator for poor encapsulation. You could resolve this by using getters and setters or by restricting the visibility, if possible.");

    public IdenticalFindingTypeReviewComment(FindingsForReviewComment findingsForReviewComment, CommitDescriptor commentedCommit, TeamscaleCommitLinkProvider linkProvider) {
        super(findingsForReviewComment, commentedCommit, linkProvider);
    }

    private String getFormatString(boolean escapeMarkdownSymbols) {
        if (TYPE_IDS_TO_INTRODUCTION_MESSAGE_MAP.containsKey(this.finding.getTypeId())) {
            return TYPE_IDS_TO_INTRODUCTION_MESSAGE_MAP.get(this.finding.getTypeId());
        }
        if (escapeMarkdownSymbols) {
            return DEFAULT_MESSAGE + this.finding.getMessage();
        }
        return DEFAULT_MESSAGE + MarkupUtils.unescapeMarkdownRelevantSymbols((String)this.finding.getMessage());
    }

    @Override
    public String getText() {
        return this.getCommentText("[New] ", "Line %d: %s", "\n", false, true);
    }

    @Override
    public String getTextWithoutLinks() {
        return this.getCommentText("[New] ", "line %d", ", ", false, false);
    }

    @Override
    public String getMarkdownText() {
        return this.getCommentText("**[New]** ", "[Line %d](%s)", ",\n", true, true);
    }

    private String getCommentText(String label, String findingFormatString, String findingSeparator, boolean escapeMarkdownSymbols, boolean addLinks) {
        StringBuilder sb = new StringBuilder();
        if (this.isNewFinding()) {
            sb.append(label);
        }
        String formatString = this.getFormatString(escapeMarkdownSymbols);
        List<TrackedFinding> findingsToComment = this.getFindingsToComment();
        sb.append(String.format(formatString, findingsToComment.size()));
        sb.append("\n");
        sb.append("\n");
        if (addLinks) {
            sb.append("View in Teamscale:");
            sb.append("\n");
        } else {
            sb.append("Locations: ");
        }
        sb.append(this.createFindingLocationsText(findingFormatString, findingSeparator, findingsToComment));
        return sb.toString();
    }

    private String createFindingLocationsText(String findingFormatString, String findingSeparator, List<TrackedFinding> findingsToComment) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < findingsToComment.size() && i < 10; ++i) {
            if (i > 0) {
                sb.append(findingSeparator);
            }
            TrackedFinding finding = findingsToComment.get(i);
            sb.append(String.format(findingFormatString, FindingUtils.getStartLine(finding), this.linkProvider.createFindingsDetailLink(finding.getId())));
        }
        if (findingsToComment.size() > 10) {
            sb.append(findingSeparator).append("and ").append(findingsToComment.size() - 10).append(" more...");
        }
        return sb.toString();
    }

    private List<TrackedFinding> getFindingsToComment() {
        return this.findingsForReviewComment.getAllFindings().stream().sorted(new TrackedFinding.TrackedFindingComparator()).collect(Collectors.toList());
    }
}

