/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdBase;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricValueDeserializer;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.metrics.values.IMetricValue;
import com.teamscale.index.metrics.assessment.ETrend;
import com.teamscale.index.metrics.assessment.TrendDelta;
import com.teamscale.index.metrics.assessment.computation.NumericMetricComputation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.text.ParseException;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class MetricAssessment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SCHEMA_ENTRY_PROPERTY = "schemaEntry";
    private static final String VALUE_PROPERTY = "value";
    private static final String RATING_PROPERTY = "rating";
    private static final String BASELINE_RATING_PROPERTY = "baseRating";
    private static final String TREND_PROPERTY = "trend";
    private static final String TREND_DELTA_PROPERTY = "trendDelta";
    private static final String AVAILABLE_IN_PROJECT_PROPERTY = "availableInProject";
    private static final String METRIC_THRESHOLDS_PROPERTY = "metricThresholds";
    @JsonProperty(value="schemaEntry")
    private final MetricDirectorySchemaEntry schemaEntry;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="value")
    @Schema(implementation=MetricDirectoryEntry.MetricValue.class)
    @JsonDeserialize(using=MetricValueDeserializer.class)
    private final @Nullable Object value;
    @JsonProperty(value="subPath")
    private final @Nullable String subPath;
    @JsonProperty(value="rating")
    private final @Nullable ETrafficLightColor rating;
    @JsonProperty(value="baseRating")
    private final @Nullable ETrafficLightColor baselineRating;
    @JsonProperty(value="trend")
    private final @Nullable ETrend trend;
    @JsonProperty(value="trendDelta")
    private final @Nullable TrendDelta trendDelta;
    @JsonProperty(value="availableInProject")
    private final boolean availableInProject;
    @JsonProperty(value="metricThresholds")
    private final EvaluatedMetricThreshold metricThresholds;

    public MetricAssessment(IMetricValue<?> value, ETrafficLightColor rating, ETrafficLightColor baselineRating, ETrend trend, TrendDelta trendDelta, EvaluatedMetricThreshold metricThreshold) {
        this(value.getSchemaEntry(), value.getOrNull(), trend, rating, baselineRating, trendDelta, true, metricThreshold);
    }

    public MetricAssessment(MetricDirectorySchemaEntry schemaEntry, IMetricValue<?> value, ETrafficLightColor rating, ETrend trend, TrendDelta trendDelta, EvaluatedMetricThreshold metricThreshold, boolean availableInProject) {
        this(schemaEntry, value.getOrNull(), trend, rating, null, trendDelta, availableInProject, metricThreshold);
    }

    @JsonCreator
    public MetricAssessment(@JsonProperty(value="schemaEntry") MetricDirectorySchemaEntry schemaEntry, @JsonProperty(value="value") @Nullable Object value, @JsonProperty(value="trend") @Nullable ETrend trend, @JsonProperty(value="rating") @Nullable ETrafficLightColor rating, @JsonProperty(value="baseRating") @Nullable ETrafficLightColor baselineRating, @JsonProperty(value="trendDelta") @Nullable TrendDelta trendDelta, @JsonProperty(value="availableInProject") boolean availableInProject, @JsonProperty(value="metricThresholds") EvaluatedMetricThreshold metricThreshold) {
        this.displayName = MetricAssessment.getMetricDisplayName(schemaEntry.getName(), (MetricThresholdBase)metricThreshold);
        this.schemaEntry = schemaEntry;
        this.value = value;
        this.trend = trend;
        this.rating = rating;
        this.baselineRating = baselineRating;
        this.trendDelta = trendDelta;
        this.availableInProject = availableInProject;
        this.metricThresholds = metricThreshold;
        this.subPath = metricThreshold.getSubPath();
    }

    private static String getMetricDisplayName(String metricName, @Nullable MetricThresholdBase metricThreshold) {
        if (metricThreshold == null) {
            return metricName;
        }
        return metricThreshold.getDisplayName();
    }

    public MetricDirectorySchemaEntry getSchemaEntry() {
        return this.schemaEntry;
    }

    public @Nullable ETrafficLightColor getRating() {
        return this.rating;
    }

    public @Nullable ETrafficLightColor getBaselineRating() {
        return this.baselineRating;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public String getMetricName() {
        return this.schemaEntry.getName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TrendDelta getTrendDelta() {
        return Objects.requireNonNullElse(this.trendDelta, TrendDelta.EMPTY);
    }

    public @Nullable ETrend getTrend() {
        return this.trend;
    }

    public EvaluatedMetricThreshold getMetricThreshold() {
        return this.metricThresholds;
    }

    public @Nullable String getSubPath() {
        return this.subPath;
    }

    public boolean hasDelta() {
        ETrend trend = this.getTrend();
        return trend != ETrend.STABLE && trend != ETrend.NA;
    }

    public Optional<Double> getAbsoluteDelta() {
        if (this.schemaEntry.getValueType() != EMetricValueType.NUMERIC) {
            return Optional.empty();
        }
        if (!this.getTrendDelta().isAvailable()) {
            return Optional.empty();
        }
        String delta = this.getTrendDelta().formattedText();
        delta = StringUtils.stripSuffix((String)delta, (String)"%");
        try {
            return Optional.of(Math.abs(NumericMetricComputation.NUMERIC_TREND_NUMBER_FORMAT.parse(delta).doubleValue()));
        }
        catch (NumberFormatException | ParseException e) {
            return Optional.empty();
        }
    }

    public Optional<Double> getNumericValue() {
        Object object = this.value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class}, (Object)object, n)) {
            case 0 -> {
                Number number = (Number)object;
                yield Optional.of(number.doubleValue());
            }
            default -> Optional.empty();
        };
    }

    public boolean isLowBad() {
        return this.schemaEntry.hasProperty(EMetricProperty.LOW_IS_BAD);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricAssessment that = (MetricAssessment)o;
        return this.availableInProject == that.availableInProject && Objects.equals(this.schemaEntry, that.schemaEntry) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.value, that.value) && Objects.equals(this.subPath, that.subPath) && this.rating == that.rating && this.trend == that.trend && Objects.equals(this.trendDelta, that.trendDelta) && Objects.equals(this.metricThresholds, that.metricThresholds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schemaEntry, this.displayName, this.value, this.subPath, this.rating, this.trend, this.trendDelta, this.availableInProject, this.metricThresholds});
    }
}

