/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion31BitbucketServerVotingOption {
    private static final String BITBUCKET_SERVER_CONNECTOR_TYPE = "Bitbucket Server (On-Premise)";
    private static final String GENERAL_VOTE_OPTION_NAME = "Enable Voting for Findings";
    private static final String VOTE_AS_BUILD_STATUS_OPTION_NAME = "Vote as build status";

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion31BitbucketServerVotingOption::migrateConnectorConfiguration);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration migrateConnectorConfiguration(ConnectorConfiguration connectorConfiguration) {
        if (BITBUCKET_SERVER_CONNECTOR_TYPE.equals(connectorConfiguration.getRawType())) {
            boolean isVotingEnabled = Boolean.parseBoolean(connectorConfiguration.getOptionValue(GENERAL_VOTE_OPTION_NAME));
            boolean isVotingAsCommitStatusEnabled = Boolean.parseBoolean(connectorConfiguration.getOptionValue(VOTE_AS_BUILD_STATUS_OPTION_NAME));
            boolean oldValue = isVotingEnabled && isVotingAsCommitStatusEnabled;
            connectorConfiguration.removeOption(VOTE_AS_BUILD_STATUS_OPTION_NAME);
            connectorConfiguration.setOptionValue(GENERAL_VOTE_OPTION_NAME, Boolean.toString(oldValue));
        }
        return connectorConfiguration;
    }
}

