/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

@Index(name="image-slide-index", options={EStorageOption.BACKUP}, valueClasses={byte[].class})
public class ImageSlideIndex
extends IndexBase
implements IGlobalIndex {
    public static final String INDEX_NAME = "image-slide-index";

    public ImageSlideIndex(IStore store) {
        super(store);
    }

    public byte[] getSlideImage(String imageId) throws StorageException {
        return (byte[])StorageUtils.deserialize((byte[])this.store.getWithString(imageId));
    }

    public void storeSlideImage(String imageId, byte[] image) throws StorageException {
        this.store.putWithString(imageId, StorageUtils.serialize((Serializable)image));
    }

    public List<String> getAllImageIds() throws StorageException {
        return StorageUtils.listStringKeys((IStore)this.store);
    }

    public void removeImages(Collection<String> imageIds) throws StorageException {
        this.store.removeWithStrings(new ArrayList<String>(imageIds));
    }
}

