/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.query;

import com.teamscale.core.user.User;
import com.teamscale.index.query.ReplacePreprocessorBase;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;

public class CurrentUserPreprocessor
extends ReplacePreprocessorBase {
    private static final String CURRENT_USER_KEYWORD = "currentUser()";
    private final User currentUser;

    public CurrentUserPreprocessor(User currentUser) {
        this.currentUser = currentUser;
    }

    private void insertUserNames(List<QueryToken> result, int tokenPosition) {
        result.add(new QueryToken(EQueryTokenType.BRACKET_OPEN, "[", (long)tokenPosition));
        result.add(new QueryToken(EQueryTokenType.LITERAL, this.currentUser.getUsername(), (long)tokenPosition));
        CurrentUserPreprocessor.insertUserName(this.currentUser.getFullName(), result, tokenPosition);
        CurrentUserPreprocessor.insertUserName(this.currentUser.getEmailAddress(), result, tokenPosition);
        for (String alias : this.currentUser.getAliases()) {
            CurrentUserPreprocessor.insertUserName(alias, result, tokenPosition);
        }
        result.add(new QueryToken(EQueryTokenType.BRACKET_CLOSE, "]", (long)tokenPosition));
    }

    private static void insertUserName(String userName, List<QueryToken> result, int tokenPosition) {
        if (!userName.isEmpty()) {
            result.add(new QueryToken(EQueryTokenType.COMMA, ",", (long)tokenPosition));
            result.add(new QueryToken(EQueryTokenType.LITERAL, userName, (long)tokenPosition));
        }
    }

    @Override
    protected String getKeyword() {
        return CURRENT_USER_KEYWORD;
    }

    @Override
    protected int insertReplacement(int index, List<QueryToken> tokens, List<QueryToken> result, Set<String> encounteredValues) {
        result.remove(result.size() - 1);
        result.add(new QueryToken(EQueryTokenType.IN, "in", (long)tokens.get(index - 1).getPosition()));
        this.insertUserNames(result, tokens.get(index).getPosition());
        return 0;
    }
}

