/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.coverage.bullseye;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class BullseyeReportHandler
extends DefaultHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private String currentFolder = "";
    private String currentSourceFile = null;
    private final TwoDimHashMap<String, Integer, Probe> probes = new TwoDimHashMap();
    private final TwoDimHashMap<String, Integer, Boolean> blocks = new TwoDimHashMap();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        switch (qName) {
            case "src": {
                this.currentSourceFile = attributes.getValue("name");
                if (StringUtils.isEmpty((String)this.currentFolder)) break;
                this.currentSourceFile = this.currentFolder + "/" + this.currentSourceFile;
                break;
            }
            case "probe": {
                this.handleProbe(attributes);
                break;
            }
            case "block": {
                this.handleBlock(attributes);
                break;
            }
            case "folder": {
                String folder = attributes.getValue("name");
                if ("..".equals(folder)) break;
                this.currentFolder = this.currentFolder + "/" + folder;
                break;
            }
        }
    }

    private void handleBlock(Attributes attributes) {
        try {
            int line = Integer.parseInt(attributes.getValue("line"));
            boolean entered = "1".equals(attributes.getValue("entered"));
            this.blocks.putValue((Object)this.currentSourceFile, (Object)line, (Object)entered);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Ignoring block with line number: " + attributes.getValue("line"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("folder")) {
            this.currentFolder = StringUtils.removeLastPart((String)this.currentFolder, (char)'/');
        }
    }

    private void handleProbe(Attributes attributes) {
        try {
            int line = Integer.parseInt(attributes.getValue("line"));
            EProbeKind probeKind = (EProbeKind)EnumUtils.valueOfIgnoreCase(EProbeKind.class, (String)attributes.getValue("kind").replace("-", "_"));
            if (probeKind == null) {
                return;
            }
            EProbeEvent probeEvent = (EProbeEvent)EnumUtils.valueOfIgnoreCase(EProbeEvent.class, (String)attributes.getValue("event"));
            Probe probe = new Probe(line, probeKind, probeEvent);
            this.probes.putValue((Object)this.currentSourceFile, (Object)line, (Object)probe);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Ignoring probe with invalid line number: " + attributes.getValue("line"));
        }
    }

    public Set<String> getFiles() {
        return this.probes.getFirstKeys();
    }

    public @Nullable Probe getProbe(String file, ShallowEntity entity) {
        return BullseyeReportHandler.getEntityInfo(this.probes, file, entity);
    }

    public @Nullable Boolean getBlockWasEntered(String file, ShallowEntity entity) {
        return BullseyeReportHandler.getEntityInfo(this.blocks, file, entity);
    }

    private static <T> T getEntityInfo(TwoDimHashMap<String, Integer, T> from, String file, ShallowEntity entity) {
        if (!entity.hasValidStartToken()) {
            LOGGER.error("Entity " + entity.getName() + " does not have valid start token. (" + file + ")");
            return null;
        }
        int lastLine = entity.getStartLine();
        IToken lastTokenInEntity = (IToken)CollectionUtils.getLast((List)entity.ownStartTokens());
        if (lastTokenInEntity != null) {
            lastLine = Math.max(lastLine, lastTokenInEntity.getLineNumber() + 1);
        }
        for (int line = entity.getStartLine(); line <= lastLine; ++line) {
            Object result = from.getValue((Object)file, (Object)line);
            if (result == null) continue;
            return (T)result;
        }
        return null;
    }

    public static enum EProbeKind {
        FUNCTION,
        DECISION,
        SWITCH_LABEL,
        CATCH,
        FOR_RANGE_BODY;

    }

    public static enum EProbeEvent {
        NONE,
        TRUE,
        FALSE,
        FULL;

    }

    public static class Probe {
        private final int line;
        private final EProbeKind probeKind;
        private final EProbeEvent probeEvent;

        public Probe(int line, EProbeKind probeKind, EProbeEvent probeEvent) {
            this.line = line;
            this.probeKind = probeKind;
            this.probeEvent = probeEvent;
        }

        public int getLine() {
            return this.line;
        }

        public EProbeKind getProbeKind() {
            return this.probeKind;
        }

        public EProbeEvent getProbeEvent() {
            return this.probeEvent;
        }

        public String toString() {
            return "Probe [line=" + this.line + ", probeType=" + String.valueOf((Object)this.probeKind) + ", probeEvent=" + String.valueOf((Object)this.probeEvent) + "]";
        }
    }
}

