/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.findbugs;

import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FindbugsMessageManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static FindbugsMessageManager instance = null;
    private final Map<String, String> shortDescriptionToTypes = new HashMap<String, String>();
    private final Map<String, String> shortDescriptions = new HashMap<String, String>();
    private final Map<String, String> detailedDescriptions = new HashMap<String, String>();
    private final Map<String, String> categoryNames = new HashMap<String, String>();
    private final Map<String, String> bugCategories = new HashMap<String, String>();

    private FindbugsMessageManager() throws ConQATException {
        try (InputStream findbugsMessages = FindbugsMessageManager.getDescriptionStream("findbugs/findbugs_legacy/messages.xml");
             InputStream findbugsCategories = FindbugsMessageManager.getDescriptionStream("findbugs/findbugs_legacy/findbugs.xml");
             InputStream spotbugsMessages = FindbugsMessageManager.getDescriptionStream("findbugs/spotbugs/messages.xml");
             InputStream spotbugsCategories = FindbugsMessageManager.getDescriptionStream("findbugs/spotbugs/findbugs.xml");
             InputStream findSecBugsMessages = FindbugsMessageManager.getDescriptionStream("findbugs/findsecbugs/messages.xml");
             InputStream findSecBugsCategories = FindbugsMessageManager.getDescriptionStream("findbugs/findsecbugs/findbugs.xml");){
            this.readMessages(XMLUtils.parse((InputSource)new InputSource(findbugsMessages)));
            this.readMessages(XMLUtils.parse((InputSource)new InputSource(spotbugsMessages)));
            this.readMessages(XMLUtils.parse((InputSource)new InputSource(findSecBugsMessages)));
            this.readCategories(XMLUtils.parse((InputSource)new InputSource(findbugsCategories)));
            this.readCategories(XMLUtils.parse((InputSource)new InputSource(spotbugsCategories)));
            this.readCategories(XMLUtils.parse((InputSource)new InputSource(findSecBugsCategories)));
        }
        catch (SAXException e) {
            throw new ConQATException("Parsing error!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not parse findbugs check descriptions", (Throwable)e);
        }
        catch (IOException e) {
            throw new ConQATException("I/O error!", (Throwable)e);
        }
    }

    private static InputStream getDescriptionStream(String descriptionPath) throws FileNotFoundException {
        return CheckDescriptionLoader.getCheckDescription(FindbugsMessageManager.class, (String)descriptionPath).map(StringUtils::toInputStream).orElseThrow(() -> new FileNotFoundException(descriptionPath));
    }

    private void readCategories(Document findbugsDoc) {
        CCSMAssert.isFalse((boolean)this.categoryNames.isEmpty(), (String)"Must be called after readMessages");
        for (Element bugPattern : XMLUtils.getNamedChildren((Element)findbugsDoc.getDocumentElement(), (String)"BugPattern")) {
            String type = bugPattern.getAttribute("type");
            String category = bugPattern.getAttribute("category");
            this.bugCategories.put(type, this.categoryNames.get(category));
        }
    }

    private void readMessages(Document doc) {
        for (Element bugPattern : XMLUtils.getNamedChildren((Element)doc.getDocumentElement(), (String)"BugPattern")) {
            String type = bugPattern.getAttribute("type");
            String shortDescription = FindbugsMessageManager.extractElementText(bugPattern, "ShortDescription");
            this.shortDescriptionToTypes.put(shortDescription, type);
            this.shortDescriptions.put(type, shortDescription);
            this.detailedDescriptions.put(type, MarkupUtils.trimLines((String)FindbugsMessageManager.extractElementText(bugPattern, "Details")));
        }
        for (Element bugCategory : XMLUtils.getNamedChildren((Element)doc.getDocumentElement(), (String)"BugCategory")) {
            String category = bugCategory.getAttribute("category");
            this.categoryNames.put(category, FindbugsMessageManager.extractElementText(bugCategory, "Description"));
        }
    }

    private static String extractElementText(Element parent, String elementName) {
        Element element = XMLUtils.getNamedChild((Element)parent, (String)elementName);
        if (element == null) {
            return "";
        }
        return element.getTextContent();
    }

    public static FindbugsMessageManager getInstance() throws ConQATException {
        if (instance == null) {
            instance = new FindbugsMessageManager();
        }
        return instance;
    }

    public UnmodifiableSet<String> getRuleIds() {
        return CollectionUtils.asUnmodifiable(this.shortDescriptions.keySet());
    }

    public String getTypeForShortDescription(String shortDescription) {
        return this.shortDescriptionToTypes.getOrDefault(shortDescription, "");
    }

    public String getShortDescription(String type) {
        return this.shortDescriptions.getOrDefault(type, "");
    }

    public String getDetailedDescription(String type) {
        return this.detailedDescriptions.getOrDefault(type, "");
    }
}

