/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.testexecution.mstest;

import java.util.Optional;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;

public enum ETrxResult {
    PASSED("Passed", ETestExecutionResult.PASSED),
    PASSED_BUT_RUN_ABORTED("PassedButRunAborted", ETestExecutionResult.PASSED),
    COMPLETED("Completed", ETestExecutionResult.PASSED),
    NOT_EXECUTED("NotExecuted", ETestExecutionResult.SKIPPED),
    FAILED("Failed", ETestExecutionResult.FAILURE),
    NOT_RUNNABLE("NotRunnable", ETestExecutionResult.ERROR),
    TIMEOUT("Timeout", ETestExecutionResult.FAILURE),
    DISCONNECTED("Disconnected", ETestExecutionResult.ERROR),
    PENDING("Pending", ETestExecutionResult.SKIPPED),
    IN_PROGRESS("InProgress", ETestExecutionResult.ERROR),
    INCONCLUSIVE("Inconclusive", ETestExecutionResult.ERROR);

    private final String outcome;
    private final ETestExecutionResult result;

    private ETrxResult(String outcome, ETestExecutionResult result) {
        this.outcome = outcome;
        this.result = result;
    }

    public static Optional<ETestExecutionResult> getFromResultString(String outcome) {
        for (ETrxResult result : ETrxResult.values()) {
            if (!result.outcome.equalsIgnoreCase(outcome)) continue;
            return Optional.of(result.result);
        }
        return Optional.empty();
    }
}

