/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store.s3;

import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import com.teamscale.index.repository.artifact_store.s3.S3ChangeRetriever;
import com.teamscale.index.s3.S3ProjectConfigurationUtils;
import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.lang.ObjectUtils;

public class S3ForceFullScan {
    private final IndexLayer indexLayer;

    public S3ForceFullScan(IndexLayer indexLayer) {
        this.indexLayer = indexLayer;
    }

    public void setS3FullScan(PublicProjectId projectId, boolean scheduleS3ChangeRetrieverTrigger) throws StorageException {
        ProjectConfiguration projectConfiguration = this.getProjectConfig(projectId);
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)projectId);
        boolean externalStorageScanWasScheduled = this.scheduleExternalStorageFullScan((ProjectStorageSystem)projectStorageSystem, projectId, projectConfiguration, scheduleS3ChangeRetrieverTrigger);
        List<ConnectorConfiguration> s3Connectors = S3ProjectConfigurationUtils.getS3Connectors(projectConfiguration);
        if (s3Connectors.isEmpty() && !externalStorageScanWasScheduled) {
            throw new NotFoundException("No S3 connector found in project '" + String.valueOf(projectId) + "'.");
        }
        for (ConnectorConfiguration connector : s3Connectors) {
            this.scheduleFullScan((ProjectStorageSystem)projectStorageSystem, projectId, connector.getIdentifier(), TriggerBuilder.buildTriggerName((String)connector.getIdentifier(), (String)TriggerBuilder.getSimpleTriggerName(S3ChangeRetriever.class)), scheduleS3ChangeRetrieverTrigger);
        }
    }

    private boolean scheduleExternalStorageFullScan(ProjectStorageSystem projectStorageSystem, PublicProjectId projectId, ProjectConfiguration projectConfig, boolean scheduleS3ChangeRetrieverTrigger) throws StorageException {
        ExternalStorageBackendIndex externalStorageBackendIndex = (ExternalStorageBackendIndex)this.indexLayer.openGlobalIndex(ExternalStorageBackendIndex.class);
        if (!S3ProjectConfigurationUtils.hasS3StorageBackend(projectConfig, externalStorageBackendIndex)) {
            return false;
        }
        this.scheduleFullScan(projectStorageSystem, projectId, "external-analysis-data", EExternalStorageBackendProtocol.S3.getChangeRetrieverTriggerName(), scheduleS3ChangeRetrieverTrigger);
        return true;
    }

    private void scheduleFullScan(ProjectStorageSystem projectStorageSystem, PublicProjectId projectId, String connectorIdentifier, String changeRetrieverName, boolean scheduleS3ChangeRetrieverTrigger) throws StorageException {
        S3ArchiveIndex.open(projectStorageSystem, connectorIdentifier).runWithIncrementalScanLock(index -> index.setForceFullScan(true));
        if (scheduleS3ChangeRetrieverTrigger) {
            ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.indexLayer, this.indexLayer.resolveToInternalProjectId((IProjectId)projectId), changeRetrieverName);
        }
    }

    private ProjectConfiguration getProjectConfig(PublicProjectId projectId) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectId, (IndexLayer)this.indexLayer);
        return (ProjectConfiguration)ObjectUtils.requireNonNullElseThrow((Object)projectConfiguration, () -> {
            throw new NotFoundException("Project with ID '" + String.valueOf(projectId) + "' was not found.");
        });
    }
}

