/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.committree;

import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.ECommitTreeNodeState;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public interface ICommitTreeNodeAdjuster {
    public void adjustTimestamps(List<CommitTreeNode> var1) throws StorageException;

    public static List<CommitTreeNode> sortNodesInAdjustmentOrder(Collection<CommitTreeNode> nodes) {
        for (CommitTreeNode node : nodes) {
            CCSMAssert.isTrue((node.getState() == ECommitTreeNodeState.UNPROCESSED ? 1 : 0) != 0, () -> "Encountered node for timestamp readjustment which isn't in state " + String.valueOf(ECommitTreeNodeState.UNPROCESSED) + ":" + String.valueOf(node));
        }
        return CollectionUtils.bottomSortNoCyclesExpected(nodes, CommitTreeNode::getParents);
    }
}

