/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.index.repository.git.TeamscaleGitCredentialsProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;

class ApacheMinaSshSessionFactory
extends SshdSessionFactory {
    private final URI uri;
    private final TeamscaleGitCredentialsProvider credentials;

    ApacheMinaSshSessionFactory(URI location, TeamscaleGitCredentialsProvider credentials) {
        this.uri = location;
        this.credentials = credentials;
    }

    protected File getSshConfig(File sshDir) {
        return null;
    }

    protected String getDefaultPreferredAuthentications() {
        return "publickey";
    }

    protected ServerKeyDatabase getServerKeyDatabase(File homeDir, File sshDir) {
        return new ServerKeyDatabase(this){

            public List<PublicKey> lookup(String connectAddress, InetSocketAddress remoteAddress, ServerKeyDatabase.Configuration config) {
                return Collections.emptyList();
            }

            public boolean accept(String connectAddress, InetSocketAddress remoteAddress, PublicKey serverKey, ServerKeyDatabase.Configuration config, CredentialsProvider provider) {
                return true;
            }
        };
    }

    protected Iterable<KeyPair> getDefaultKeys(File sshDir) {
        return new KeyAuthenticator();
    }

    private class KeyAuthenticator
    implements KeyIdentityProvider,
    Iterable<KeyPair> {
        private KeyAuthenticator() {
        }

        @Override
        public Iterator<KeyPair> iterator() {
            throw new UnsupportedOperationException("The need to implement Iterable<KeyPair> is an left-over of JGit 2.0's API; iterator() has been replaced by loadKeys(..)");
        }

        public Iterable<KeyPair> loadKeys(SessionContext session) throws IOException, GeneralSecurityException {
            return SecurityUtils.loadKeyPairIdentities((SessionContext)session, null, (InputStream)new ByteArrayInputStream(ApacheMinaSshSessionFactory.this.credentials.getSshPrivateKey().getBytes(StandardCharsets.UTF_8)), (session1, resourceKey, retryIndex) -> ApacheMinaSshSessionFactory.this.credentials.getSshPrivateKeyPassword(ApacheMinaSshSessionFactory.this.uri));
        }
    }
}

