/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.TeamscaleGitCredentialsProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ICancelable;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class GitRefFetcher {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Supplier<Git> openGit;
    private final URI location;
    private final TeamscaleGitCredentialsProvider credentials;
    private final ICancelable cancelable;

    public GitRefFetcher(Supplier<Git> openGit, URI location, TeamscaleGitCredentialsProvider credentials, ICancelable cancelable) {
        this.openGit = openGit;
        this.location = location;
        this.credentials = credentials;
        this.cancelable = cancelable;
    }

    public Collection<TrackingRefUpdate> fetch() throws GitAPIException {
        LOGGER.traceEntry();
        try (Git git = this.openGit.get();){
            FetchResult fetchResult = GitRefFetcher.callFetchCommand(this.createFetchCommand(git, null));
            Collection collection = (Collection)LOGGER.traceExit((Object)fetchResult.getTrackingRefUpdates());
            return collection;
        }
    }

    public Collection<TrackingRefUpdate> fetch(@Nullable Collection<RefSpec> refSpecs) throws GitAPIException {
        LOGGER.traceEntry("{}", new Object[]{refSpecs});
        if (refSpecs != null && refSpecs.isEmpty()) {
            return (Collection)LOGGER.traceExit(Collections.emptyList());
        }
        try (Git git = this.openGit.get();){
            FetchResult fetchResult = GitRefFetcher.callFetchCommand(this.createFetchCommand(git, refSpecs));
            Collection collection = (Collection)LOGGER.traceExit((Object)fetchResult.getTrackingRefUpdates());
            return collection;
        }
    }

    private FetchCommand createFetchCommand(Git git, @Nullable Collection<RefSpec> refSpecs) {
        LOGGER.traceEntry("{}, {}, {}", new Object[]{git.getRepository().getDirectory(), true, refSpecs});
        FetchCommand fetchCommand = ((FetchCommand)((FetchCommand)git.fetch().setTimeout(GitUtils.GIT_OPERATIONS_TIMEOUT_SECONDS)).setCredentialsProvider((CredentialsProvider)this.credentials)).setRemoveDeletedRefs(true).setTagOpt(TagOpt.FETCH_TAGS);
        if (refSpecs != null) {
            fetchCommand.setRefSpecs(new ArrayList<RefSpec>(refSpecs));
        }
        GitUtils.configureCommand(this.location, this.credentials, fetchCommand, this.cancelable);
        return (FetchCommand)LOGGER.traceExit((Object)fetchCommand);
    }

    private static FetchResult callFetchCommand(FetchCommand fetchCommand) throws GitAPIException {
        LOGGER.trace("Executing fetch: {}", new org.apache.logging.log4j.util.Supplier[]{() -> ToStringHelpers.toReflectiveStringHelper((Object)fetchCommand)});
        FetchResult result = fetchCommand.call();
        LOGGER.trace("Fetch result: {}", new org.apache.logging.log4j.util.Supplier[]{() -> ToStringHelpers.toReflectiveStringHelper((Object)result)});
        return result;
    }
}

