/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.rest.client.authentication.ERestClientAuthenticationMode;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestDeltaIndex;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestTestGapInfo;
import com.teamscale.index.merge_request.comments.RepositoryPathMapper;
import com.teamscale.index.merge_request.comments.ReviewCommentEngine;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileHistoryEntry;
import com.teamscale.index.repository.RepositoryLogFileUtils;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.gerrit.EGerritReviewVote;
import com.teamscale.index.repository.git.gerrit.GerritConfigurationParameters;
import com.teamscale.index.repository.git.gerrit.GerritIndexParameters;
import com.teamscale.index.repository.git.gerrit.GerritRestClient;
import com.teamscale.index.repository.git.gerrit.GerritUtils;
import com.teamscale.index.repository.git.gerrit.GerritVotingInput;
import com.teamscale.index.repository.git.gerrit.GerritVotingSkippedException;
import com.teamscale.index.repository.git.gerrit.data.ChangeInfo;
import com.teamscale.index.repository.git.gerrit.data.CommentInput;
import com.teamscale.index.repository.git.gerrit.data.CommentRange;
import com.teamscale.index.repository.git.gerrit.data.FileInfo;
import com.teamscale.index.repository.git.gerrit.data.ReviewInput;
import com.teamscale.index.repository.git.gerrit.data.RobotCommentInput;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.requirements_tracing.merge_request.ImpactedSpecItemsDelta;
import com.teamscale.index.requirements_tracing.merge_request.MergeRequestImpactedSpecItemsCalculator;
import com.teamscale.index.requirements_tracing.merge_request.MergeRequestImpactedSpecItemsCalculatorIndexes;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.ListMapCollector;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class GerritAnalysisResultUploader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_LENGTH_OF_COMMIT_MESSAGE_IN_REVIEW_COMMENT = 100;
    public static final int UPLOAD_TIMEOUT_SECONDS = 360;
    public static final String FINDING_LINE_COMMENT_LIMIT_WARNING = "* There are %s added findings. This number exceeds the set limit for findings to be shown as individual comments.";
    private final GerritIndexParameters indexes;
    private final TrackedFindingsByIdIndex trackedFindingsByIdIndex;
    private final TrackedFindingsByIdIndex trackedFindingsByIdIndexForPreviouslyVotedPatchSet;
    private final GerritConfigurationParameters gerritConfigurationParameters;
    private final CommitDescriptor schedulingCommit;
    private final String findingBlacklistEventString;
    private final String reviewLabel;
    private final GerritRestClient gerritRestClient;
    private final IncludeExcludeAntPatternSupport includeExcludePatterns;
    private final String gerritRepositoryConnectorId;
    private final ReviewCommentEngine reviewCommentEngine;
    private final TeamscaleCommitLinkProvider linkProvider;
    private final boolean includeTestGapInformation;
    private final IndexLayer indexLayer;
    private final InternalProjectId projectId;
    private final boolean commitAlertsEnabled;
    private final String baseUrl;

    public GerritAnalysisResultUploader(CommitDescriptor schedulingCommit, String findingBlacklistEventString, String reviewLabel, ERestClientAuthenticationMode restClientAuthenticationMode, GerritIndexParameters indexes, TrackedFindingsByIdIndex trackedFindingsByIdIndex, TrackedFindingsByIdIndex trackedFindingsByIdIndexForPreviouslyVotedPatchSet, GerritConfigurationParameters gerritConfigurationParameters, TeamscaleCommitLinkProvider linkProvider, ExternalCredentials externalCredentials, IncludeExcludeAntPatternSupport includeExcludePatterns, String gerritRepositoryConnectorId, ReviewCommentEngine reviewCommentEngine, boolean includeTestGapInformation, IndexLayer indexLayer, InternalProjectId projectId, boolean commitAlertsEnabled) {
        this.schedulingCommit = schedulingCommit;
        this.findingBlacklistEventString = findingBlacklistEventString;
        this.reviewLabel = reviewLabel;
        this.indexes = indexes;
        this.trackedFindingsByIdIndex = trackedFindingsByIdIndex;
        this.trackedFindingsByIdIndexForPreviouslyVotedPatchSet = trackedFindingsByIdIndexForPreviouslyVotedPatchSet;
        this.includeExcludePatterns = includeExcludePatterns;
        this.gerritRepositoryConnectorId = gerritRepositoryConnectorId;
        this.commitAlertsEnabled = commitAlertsEnabled;
        if (this.includeExcludePatterns.getIncludePatterns().isEmpty()) {
            this.includeExcludePatterns.addMatchAllIncludePattern();
        }
        this.gerritConfigurationParameters = gerritConfigurationParameters;
        this.linkProvider = linkProvider;
        this.reviewCommentEngine = reviewCommentEngine;
        this.includeTestGapInformation = includeTestGapInformation;
        this.indexLayer = indexLayer;
        this.projectId = projectId;
        this.gerritRestClient = new GerritRestClient(externalCredentials.uri, externalCredentials.username, externalCredentials.password, Collections.emptyList(), 360, restClientAuthenticationMode);
        this.baseUrl = externalCredentials.uri;
    }

    public VotingRecord.EVotingState execute() throws StorageException, VotingException {
        GerritVotingInput votingInput = this.calculateVotingInput();
        this.persistVotingInput(votingInput);
        return this.uploadVotingInput(votingInput);
    }

    private RepositoryLogEntryAggregate getMostRecentGerritCommit() throws VotingException, StorageException {
        RepositoryLogEntryAggregate logEntry = Objects.requireNonNull((RepositoryLogEntryAggregate)this.indexes.repositoryLogIndex.getEntry(this.schedulingCommit));
        if (this.isGerritCommit(logEntry)) {
            return logEntry;
        }
        List<CommitDescriptor> commitsOnReviewedBranch = this.getCommitsOnReviewedBranch();
        for (int i = commitsOnReviewedBranch.size() - 1; i >= 0; --i) {
            logEntry = Objects.requireNonNull((RepositoryLogEntryAggregate)this.indexes.repositoryLogIndex.getEntry(commitsOnReviewedBranch.get(i)));
            if (!this.isGerritCommit(logEntry)) continue;
            return logEntry;
        }
        throw new VotingException.Error(this.schedulingCommit, "No Gerrit commit found on branch: " + this.schedulingCommit.getBranchName());
    }

    private boolean isGerritCommit(RepositoryLogEntryAggregate logEntry) {
        return logEntry.getRevision() != null && logEntry.containsRepositoryIdentifier(this.gerritRepositoryConnectorId);
    }

    public GerritVotingInput calculateVotingInput() throws VotingException, StorageException {
        if (!GerritUtils.isGerritBranch(this.schedulingCommit.getBranchName())) {
            throw GerritVotingSkippedException.notAGerritBranch(this.schedulingCommit);
        }
        RepositoryLogEntryAggregate logEntryToVoteOn = this.getMostRecentGerritCommit();
        String changeNumber = GerritUtils.getChangeNumber(logEntryToVoteOn.getCommit().getBranchName());
        try {
            ChangeInfo changeInfo = this.gerritRestClient.getChangeDetails(changeNumber);
            MergeRequest mergeRequest = this.createMergeRequest(logEntryToVoteOn, changeInfo);
            if (mergeRequest.status != EMergeRequestStatus.OPEN) {
                throw GerritVotingSkippedException.mergedOrAbandoned(this.schedulingCommit);
            }
            Set<String> changedFiles = this.gerritRestClient.getChangedFiles(changeNumber, logEntryToVoteOn.getRevision()).keySet();
            changedFiles.remove(FileInfo.getCommitMsg());
            changedFiles.remove(FileInfo.getMergeList());
            return this.createReviewInput(mergeRequest, logEntryToVoteOn, changedFiles);
        }
        catch (ServiceCallException e) {
            throw new VotingException.Error(this.schedulingCommit, "Problem getting data from Gerrit for change: " + changeNumber, e);
        }
    }

    private boolean shouldCommentOnlyCommitDelta(RepositoryLogEntry logEntryToVoteOn) {
        return !logEntryToVoteOn.getCommit().equals((Object)this.schedulingCommit);
    }

    public void persistVotingInput(GerritVotingInput votingInput) throws StorageException {
        MergeBaseInfo mergeBaseInfo = null;
        FindingChurnList findingChurn = new FindingChurnList(votingInput.logEntryToVoteOn.getCommit());
        ImpactedSpecItemsDelta impactedSpecItemsDelta = new ImpactedSpecItemsDelta();
        MergeRequestTestGapInfo testGapInfo = null;
        if (votingInput instanceof GerritVotingInput.WithDelta) {
            MergeRequestImpactedSpecItemsCalculatorIndexes indexes;
            GerritVotingInput.WithDelta deltaInput = (GerritVotingInput.WithDelta)votingInput;
            findingChurn.addAddedFindings(deltaInput.filteredFindings.findingsAddedOnBranch);
            mergeBaseInfo = deltaInput.mergeBase;
            testGapInfo = deltaInput.testGapInfo;
            if (this.indexes.getProjectStorageSystem() != null && this.indexes.getGlobalStorageSystem() != null && (indexes = new MergeRequestImpactedSpecItemsCalculatorIndexes(deltaInput.lastCommit, deltaInput.mergeBase, this.indexes.getProjectStorageSystem(), this.indexes.getGlobalStorageSystem(), this.indexes.getParallelTaskExecutor())).specItemReferencesPresentInCodeBase()) {
                MergeRequestImpactedSpecItemsCalculator impactedSpecItemCalculator = new MergeRequestImpactedSpecItemsCalculator(indexes, new ArrayList<String>(deltaInput.changedFiles));
                impactedSpecItemsDelta = impactedSpecItemCalculator.calculateDelta();
            }
        }
        CounterSet testGapStates = Optional.ofNullable(testGapInfo).map(MergeRequestTestGapInfo::testGapStates).orElse(null);
        this.storeMergeRequest(votingInput.mergeRequest, mergeBaseInfo, findingChurn, impactedSpecItemsDelta, (CounterSet<ETestGapState>)testGapStates);
    }

    public VotingRecord.EVotingState uploadVotingInput(GerritVotingInput votingInput) throws StorageException, VotingException {
        try {
            ReviewInput reviewInput = this.createReviewInput(votingInput);
            if (this.shouldCommentOnlyCommitDelta(votingInput.logEntryToVoteOn) && !reviewInput.hasComments()) {
                throw GerritVotingSkippedException.emptyCommitAndNoComments(this.schedulingCommit);
            }
            this.gerritRestClient.uploadReview(votingInput.changeNumber, votingInput.logEntryToVoteOn.getRevision(), reviewInput);
            Collection<String> reviewVotes = reviewInput.getReviewVotes();
            if (reviewVotes.contains(EGerritReviewVote.REJECT.getLabel()) || reviewVotes.contains(EGerritReviewVote.DISLIKE.getLabel())) {
                return VotingRecord.EVotingState.VOTED_NEGATIVE;
            }
            return VotingRecord.EVotingState.VOTED_POSITIVE;
        }
        catch (ServiceCallException e) {
            throw new VotingException.Error(this.schedulingCommit, "Problem uploading review to Gerrit: " + e.getMessage(), e);
        }
    }

    private MergeRequest createMergeRequest(RepositoryLogEntryAggregate logEntryToVoteOn, ChangeInfo changeInfo) {
        MergeRequestIdentifier id = new MergeRequestIdentifier(this.gerritRepositoryConnectorId, changeInfo.getNumber().longValue());
        EMergeRequestStatus status = EMergeRequestStatus.OPEN;
        if ("MERGED".equals(changeInfo.getStatus())) {
            status = EMergeRequestStatus.MERGED;
        } else if ("ABANDONED".equals(changeInfo.getStatus())) {
            status = EMergeRequestStatus.OTHER;
        }
        return new MergeRequest(id, status, StringUtils.getFirstLine((String)logEntryToVoteOn.getMessage()), new MergeRequestProvider.SourceBranchAndCommit(logEntryToVoteOn.getCommit().getBranchName(), logEntryToVoteOn.getRevision()), changeInfo.getBranch(), GerritAnalysisResultUploader.getUrl(this.baseUrl, changeInfo, logEntryToVoteOn), Instant.now().toEpochMilli(), Instant.now().toEpochMilli());
    }

    private static String getUrl(String baseUrl, String repositoryName, long changeNumber, long patchNumber) {
        return StringUtils.ensureEndsWith((String)baseUrl, (String)"/") + "c/" + repositoryName + "/+/" + changeNumber + "/" + patchNumber;
    }

    private static String getUrl(String baseUrl, ChangeInfo changeInfo, RepositoryLogEntryAggregate logEntryToVoteOn) {
        String branchName = logEntryToVoteOn.getCommit().getBranchName();
        long patchNumber = Long.parseLong(branchName.substring(branchName.lastIndexOf("/") + 1));
        return GerritAnalysisResultUploader.getUrl(baseUrl, changeInfo.getProject(), changeInfo.getNumber(), patchNumber);
    }

    private void storeMergeRequest(MergeRequest mergeRequest, @Nullable MergeBaseInfo mergeInfo, FindingChurnList findingChurn, ImpactedSpecItemsDelta specItemReferenceDiffs, CounterSet<ETestGapState> testGapStates) throws StorageException {
        if (mergeRequest.status == EMergeRequestStatus.OPEN) {
            this.indexes.mergeRequestIndex.reAssociateMergeRequest(mergeRequest);
            this.indexes.mergeRequestDeltaIndex.updateDelta(mergeRequest.identifier, mergeInfo, findingChurn, this.getNumberOfPendingExclusions((List<TrackedFinding>)findingChurn.getAddedFindings()), specItemReferenceDiffs, testGapStates, null);
        } else {
            Optional<MergeRequestDeltaIndex.MergeRequestDelta> delta = this.indexes.mergeRequestDeltaIndex.getDelta(mergeRequest.identifier);
            if (delta.isEmpty() && mergeRequest.shouldBeRemovedFromIndex()) {
                this.indexes.mergeRequestIndex.removeMergeRequest(mergeRequest.identifier);
            }
        }
    }

    private int getNumberOfPendingExclusions(List<TrackedFinding> addedFindings) throws StorageException {
        if (this.indexes.getProjectStorageSystem() == null) {
            return 0;
        }
        return MergeRequestAnnotationTriggerBase.getNumberOfPendingExclusions(this.indexes.getProjectStorageSystem(), addedFindings, this.schedulingCommit);
    }

    private static CommentInput createBlacklistingComment(TrackedFinding finding, FindingBlacklistInfo findingBlacklistInfo, String blackListingEvent) {
        return new CommentInput(finding.getLocation().getUniformPath(), blackListingEvent + GerritAnalysisResultUploader.formatBlacklistInfo(findingBlacklistInfo), GerritAnalysisResultUploader.createCommentRange(finding.getLocation()), false);
    }

    private static CommentRange createCommentRange(ElementLocation location) {
        if (location instanceof TextRegionLocation) {
            TextRegionLocation textLocation = (TextRegionLocation)location;
            return new CommentRange(textLocation.getRawStartLine());
        }
        return new CommentRange(1);
    }

    private static String formatBlacklistInfo(FindingBlacklistInfo findingBlacklistInfo) {
        if (findingBlacklistInfo == null) {
            return "";
        }
        return " by " + findingBlacklistInfo.getUser() + ", rationale: \"" + findingBlacklistInfo.getRationale() + "\"";
    }

    private GerritVotingInput createReviewInput(MergeRequest mergeRequest, RepositoryLogEntryAggregate logEntryToVoteOn, Set<String> changedFiles) throws StorageException, VotingException {
        List commitsOnBranch = this.indexes.commitDescriptorIndex.getCommits(this.getCommitsOnReviewedBranch());
        if (commitsOnBranch.isEmpty()) {
            LOGGER.warn("No analyzed commits found on branch {}. Falling back to default +1 vote.", (Object)this.schedulingCommit.getBranchName());
            return new GerritVotingInput.WithReviewInput(mergeRequest, logEntryToVoteOn.toAggregateLogEntryWithPrimaryRepository(), new ReviewInput(this.reviewLabel, EGerritReviewVote.RECOMMEND, Collections.emptyList(), "Teamscale Review: No changes present in Teamscale analysis scope.", Collections.emptyList()));
        }
        ParentedCommitDescriptor firstCommit = (ParentedCommitDescriptor)commitsOnBranch.getFirst();
        CommitDescriptor mergeBaseCommit = Optional.ofNullable(firstCommit.getFirstParentCommit()).orElse(firstCommit.cloneWithDecrementedTimestamp());
        Optional<ParentedCommitDescriptor> optionalLastCommit = GerritUtils.getLastRealCommitOnBranch(commitsOnBranch, this.indexes.repositoryLogIndex);
        ParentedCommitDescriptor lastCommit = optionalLastCommit.orElseThrow(() -> new VotingException.Error(this.schedulingCommit, "No viable commit found!"));
        RepositoryLogEntryAggregate logEntryForLastCommit = (RepositoryLogEntryAggregate)this.indexes.repositoryLogIndex.getEntry((CommitDescriptor)lastCommit);
        MergeBaseInfo mergeBase = new MergeBaseInfo(mergeBaseCommit, mergeBaseCommit, firstCommit, commitsOnBranch);
        Integer numberOfAffectedSpecItems = this.calculateNumberOfAffectedSpecItems(mergeBase);
        MergeRequestTestGapInfo testGapInfo = this.calculateTestGapInfo(mergeRequest, mergeBase);
        FilteredFindings filteredFindings = this.filterFindings(commitsOnBranch, changedFiles);
        CommitAlerts commitAlerts = this.getCommitAlerts();
        return new GerritVotingInput.WithDelta(mergeRequest, changedFiles, filteredFindings, logEntryToVoteOn.toAggregateLogEntryWithPrimaryRepository(), mergeBase, (CommitDescriptor)lastCommit, logEntryForLastCommit, numberOfAffectedSpecItems, testGapInfo, commitAlerts);
    }

    private CommitAlerts getCommitAlerts() throws StorageException {
        CommitAlerts commitAlerts = null;
        if (this.indexes.getProjectStorageSystem() != null && this.commitAlertsEnabled) {
            CommitAlertIndex commitAlertIndex = (CommitAlertIndex)this.indexes.getProjectStorageSystem().openProjectIndex(CommitAlertIndex.class, null);
            commitAlerts = (CommitAlerts)commitAlertIndex.getEntry(this.schedulingCommit);
        }
        return commitAlerts;
    }

    private ReviewInput createReviewInput(GerritVotingInput input) throws StorageException, VotingException {
        List<TrackedFinding> findingsRelevantForComments;
        if (input instanceof GerritVotingInput.WithReviewInput) {
            return ((GerritVotingInput.WithReviewInput)input).reviewInput;
        }
        GerritVotingInput.WithDelta votingInput = (GerritVotingInput.WithDelta)CCSMAssert.checkedCast((Object)input, GerritVotingInput.WithDelta.class);
        if (!CollectionUtils.anyMatch(votingInput.changedFiles, arg_0 -> ((IncludeExcludeAntPatternSupport)this.includeExcludePatterns).isIncluded(arg_0))) {
            throw GerritVotingSkippedException.changeDoesNotAffectIncludedFiles(this.schedulingCommit);
        }
        String mergeRequestLink = this.createMergeRequestDetailsLink(votingInput);
        EGerritReviewVote gerritVote = this.evaluateFindings(votingInput.filteredFindings);
        if (this.isUploadForBlacklistingEvent()) {
            return this.createReviewInputForBlacklisting(votingInput.logEntryForLastCommit, mergeRequestLink, gerritVote);
        }
        if (this.shouldCommentOnlyCommitDelta(input.logEntryToVoteOn)) {
            this.filterFindingsToSchedulingCommit(votingInput.filteredFindings);
        }
        boolean exceedsFindingsCommentLimit = (findingsRelevantForComments = votingInput.filteredFindings.findingsRelevantForComments).size() > votingInput.findingsCommentsLimit;
        List<RepositoryPathMapper.RepositoryReviewComment> reviewComments = this.reviewCommentEngine.getReviewComments(findingsRelevantForComments);
        CommitVotingTriggerBase.logCommentedFindingsForCommit(this.schedulingCommit, findingsRelevantForComments);
        if (votingInput.commitAlerts != null) {
            reviewComments.addAll(this.reviewCommentEngine.getReviewCommentsForAlerts(votingInput.commitAlerts));
            CommitVotingTriggerBase.logCommentedAlertsForCommit(this.schedulingCommit, votingInput.commitAlerts);
        }
        String gerritMessage = GerritAnalysisResultUploader.formatGerritMessage(StringUtils.emptyIfNull((String)votingInput.logEntryForLastCommit.getMessage()), votingInput.numberOfAffectedSpecItems, votingInput.getTestGapStates(), "", mergeRequestLink, exceedsFindingsCommentLimit, findingsRelevantForComments.size());
        return new ReviewInput(this.reviewLabel, gerritVote, Collections.emptyList(), gerritMessage, this.createComments(exceedsFindingsCommentLimit, reviewComments));
    }

    private void filterFindingsToSchedulingCommit(FilteredFindings filteredFindings) throws StorageException {
        FindingChurnList churn = (FindingChurnList)this.indexes.findingChurnListIndex.getEntry(this.schedulingCommit);
        if (churn == null) {
            filteredFindings.applyFilter(findings -> false);
            return;
        }
        HashSet addedFindingIds = new HashSet(CollectionUtils.map(churn.getAddedFindings(), TrackedFinding::getId));
        filteredFindings.applyFilter(finding -> addedFindingIds.contains(finding.getId()));
    }

    private boolean isUploadForBlacklistingEvent() {
        return !StringUtils.isEmpty((String)this.findingBlacklistEventString);
    }

    private ReviewInput createReviewInputForBlacklisting(RepositoryLogEntryAggregate logEntryForLastCommit, String linkToDeltaPerspective, EGerritReviewVote gerritVote) throws StorageException {
        FindingBlacklistEvent findingBlacklistEvent = FindingBlacklistEvent.fromString(this.findingBlacklistEventString);
        String blacklistedFindingId = findingBlacklistEvent.getFindingId();
        TrackedFinding blackListedFinding = this.trackedFindingsByIdIndex.getFinding(blacklistedFindingId);
        if (blackListedFinding == null) {
            throw new StorageException("Could not retrieve finding " + blacklistedFindingId);
        }
        FindingBlacklistInfo blacklistInfo = findingBlacklistEvent.getBlacklistInfo().orElse(null);
        String blackListingEventMessage = findingBlacklistEvent.getCommitMessage();
        CommentInput blackListComment = GerritAnalysisResultUploader.createBlacklistingComment(blackListedFinding, blacklistInfo, blackListingEventMessage);
        String blackListMessage = GerritAnalysisResultUploader.formatGerritMessage(StringUtils.emptyIfNull((String)logEntryForLastCommit.getMessage()), null, null, " (" + blackListingEventMessage + GerritAnalysisResultUploader.formatBlacklistInfo(blacklistInfo) + ")", linkToDeltaPerspective, false, -1);
        return new ReviewInput(this.reviewLabel, gerritVote, Collections.singleton(blackListComment), blackListMessage, Collections.emptyList());
    }

    private FilteredFindings filterFindings(List<ParentedCommitDescriptor> commitsOnBranch, Set<String> changedFiles) throws StorageException {
        List<TrackedFinding> findingsAddedOnBranch = this.getFindingsAddedInCommits(commitsOnBranch);
        findingsAddedOnBranch.removeIf(finding -> {
            if (!changedFiles.contains(finding.getLocation().getUniformPath())) {
                LOGGER.warn("Wanted to vote for finding '{}' in file '{}' but that file was not actually changed in {}", (Object)finding.getId(), (Object)finding.getLocation().getUniformPath(), (Object)this.schedulingCommit.toString());
                return true;
            }
            return false;
        });
        Set<UniformPath> existingPaths = this.calculateFilesInPatchset(commitsOnBranch);
        findingsAddedOnBranch.removeIf(finding -> !existingPaths.contains(UniformPathCompatibilityUtil.convert((String)finding.getLocation().getUniformPath())));
        FilteredFindings filteredFindings = new FilteredFindings(findingsAddedOnBranch, this.gerritConfigurationParameters);
        filteredFindings.applyFilter(finding -> this.includeExcludePatterns.isIncluded(finding.getLocation().getUniformPath()));
        Set<String> blacklistedIds = this.getBlacklistedIds();
        filteredFindings.applyFilter(finding -> !blacklistedIds.contains(finding.getId()));
        return filteredFindings;
    }

    private Set<UniformPath> calculateFilesInPatchset(List<ParentedCommitDescriptor> commitsOnBranch) throws StorageException {
        ExistingPaths existingPaths = new ExistingPaths();
        for (ParentedCommitDescriptor commit : commitsOnBranch) {
            List<RepositoryLogFileEntry> entries = this.indexes.repositoryLogFileIndex.getEntriesByCommitAndEntryTypes((CommitDescriptor)commit, EnumSet.of(UniformPath.EType.CODE));
            ElementHistoryIndex historyIndex = this.indexes.openElementHistoryIndex((CommitDescriptor)commit);
            RepositoryLogFileUtils.augmentWithHistoryInformation(entries, historyIndex).forEach(existingPaths::handleEntry);
        }
        return existingPaths.set;
    }

    private Integer calculateNumberOfAffectedSpecItems(MergeBaseInfo mergeBase) throws StorageException {
        Integer numberOfAffectedSpecItems = null;
        if (VotingConnectorUtils.projectHasRequirementsConnector(this.indexes.metaIndex, LOGGER) && this.indexes.getProjectStorageSystem() != null) {
            numberOfAffectedSpecItems = VotingConnectorUtils.determineImpactedSpecItemDelta(mergeBase, this.schedulingCommit, this.gerritRepositoryConnectorId, this.indexes.getProjectStorageSystem(), this.indexes.getGlobalStorageSystem(), this.indexes.getParallelTaskExecutor()).size();
        }
        return numberOfAffectedSpecItems;
    }

    private MergeRequestTestGapInfo calculateTestGapInfo(MergeRequest mergeRequest, MergeBaseInfo mergeBase) throws StorageException {
        MergeRequestTestGapInfo testGapInfo = null;
        if (this.includeTestGapInformation && this.indexes.getProjectStorageSystem() != null) {
            try {
                testGapInfo = TgaRequestUtils.calculateTestGapsForMergeRequest(this.schedulingCommit, mergeRequest.identifier, mergeBase, this.indexLayer, (IProjectId)this.projectId);
            }
            catch (BranchPointNotFoundException e) {
                LOGGER.warn("Could not calculate test gaps.", (Throwable)e);
            }
        }
        return testGapInfo;
    }

    private Collection<RobotCommentInput> createComments(boolean exceedsFindingsCommentLimit, List<RepositoryPathMapper.RepositoryReviewComment> findingsReviewComments) {
        ArrayList<RobotCommentInput> allComments = new ArrayList<RobotCommentInput>();
        if (!exceedsFindingsCommentLimit && this.gerritConfigurationParameters.isDetailedLineCommentsEnabled) {
            allComments.addAll(CollectionUtils.map(findingsReviewComments, comment -> new RobotCommentInput((IReviewComment)comment, this.schedulingCommit.toString())));
        }
        return allComments;
    }

    @VisibleForTesting
    public static String formatGerritMessage(String commitMessage, @Nullable Integer affectedSpecItems, @Nullable CounterSet<ETestGapState> testGapStates, String updateReason, String linkToDeltaPerspective, boolean exceedsCommentLimit, int numberOfFindings) {
        String commitTitle = commitMessage.replaceAll("\\n\\n.*", "").trim();
        commitTitle = StringUtils.truncateWithThreeDots((String)commitTitle, (int)100);
        StringBuilder builder = new StringBuilder();
        builder.append("Teamscale Review for Commit: \"").append(commitTitle).append("\"").append(updateReason).append("\n\n");
        if (affectedSpecItems != null) {
            String itemOrItems = affectedSpecItems > 1 ? "items" : "item";
            builder.append("* ").append(affectedSpecItems).append(" affected specification ").append(itemOrItems).append("\n");
        }
        if (testGapStates != null) {
            builder.append(TgaAggregationUtils.getTestGapsFormatted(testGapStates));
            builder.append("\n");
        }
        if (exceedsCommentLimit) {
            builder.append(String.format(FINDING_LINE_COMMENT_LIMIT_WARNING, numberOfFindings)).append("\n");
        }
        builder.append("* see ").append(linkToDeltaPerspective).append(" for findings and details");
        return builder.toString();
    }

    private List<CommitDescriptor> getCommitsOnReviewedBranch() throws StorageException {
        String branchName = this.schedulingCommit.getBranchName();
        List commitsOnBranch = this.indexes.commitDescriptorIndex.getAllCommitsOnBranchBetweenInclusive(new CommitDescriptor(branchName, 0L), this.schedulingCommit);
        CollectionUtils.sort((Collection)commitsOnBranch);
        return commitsOnBranch;
    }

    private EGerritReviewVote evaluateFindings(FilteredFindings filteredFindings) {
        if (!this.gerritConfigurationParameters.isVotingEnabled) {
            return EGerritReviewVote.NO_SCORE;
        }
        if (filteredFindings.hasNoFindingsForVoting()) {
            return EGerritReviewVote.RECOMMEND;
        }
        if (filteredFindings.hasNoRedFindingsForVoting() && this.gerritConfigurationParameters.isIgnoreYellowFindingsForVotesEnabled) {
            return EGerritReviewVote.NO_SCORE;
        }
        return EGerritReviewVote.DISLIKE;
    }

    private List<TrackedFinding> getFindingsAddedInCommits(List<ParentedCommitDescriptor> commitsForBranch) throws StorageException {
        List findingChurns = this.indexes.findingChurnListIndex.getEntries(commitsForBranch);
        return this.aggregateFindings(findingChurns);
    }

    private String createMergeRequestDetailsLink(GerritVotingInput.WithDelta votingInput) {
        return this.linkProvider.createMergeRequestDetailsLink(votingInput.mergeRequest.identifier);
    }

    private List<TrackedFinding> aggregateFindings(List<FindingChurnList> findingChurns) throws StorageException {
        HashSet findingIds = new HashSet();
        for (FindingChurnList findingChurn : CollectionUtils.filterNullEntries(findingChurns)) {
            findingChurn.getAddedFindings().forEach(addedFinding -> findingIds.add(addedFinding.getId()));
            findingChurn.getRemovedFindings().forEach(removedFinding -> findingIds.remove(removedFinding.getId()));
        }
        ArrayList<String> orderedFindingIds = new ArrayList<String>(findingIds);
        List<TrackedFinding> findings = this.trackedFindingsByIdIndex.getFindings(orderedFindingIds);
        if (this.trackedFindingsByIdIndexForPreviouslyVotedPatchSet == null) {
            return findings;
        }
        List<TrackedFinding> previouslyCommentedFindings = this.trackedFindingsByIdIndexForPreviouslyVotedPatchSet.getFindings(orderedFindingIds);
        return GerritAnalysisResultUploader.updateBirthCommits(previouslyCommentedFindings, findings);
    }

    private static List<TrackedFinding> updateBirthCommits(List<TrackedFinding> previouslyCommentedFindings, List<TrackedFinding> findings) {
        ArrayList<TrackedFinding> updatedFindings = new ArrayList<TrackedFinding>(findings.size());
        CollectionUtils.forEach(previouslyCommentedFindings, findings, (oldFinding, newFinding) -> {
            if (oldFinding == null) {
                updatedFindings.add((TrackedFinding)newFinding);
                return;
            }
            TrackedFinding trackedFinding = TrackedFinding.Builder.from((TrackedFinding)newFinding).withBirthCommit(oldFinding.getBirthCommit()).build();
            updatedFindings.add(trackedFinding);
        });
        return updatedFindings;
    }

    private Set<String> getBlacklistedIds() {
        try {
            return this.indexes.findingBlacklistIndex.getAllBlacklistInfos().keySet();
        }
        catch (StorageException e) {
            LOGGER.error("Could not retrieve flagged findings", (Throwable)e);
            return Collections.emptySet();
        }
    }

    static class FilteredFindings {
        private final List<TrackedFinding> findingsAddedOnBranch;
        private final ListMap<ETrafficLightColor, TrackedFinding> findingsRelevantForVotes;
        private final List<TrackedFinding> findingsRelevantForComments;

        private FilteredFindings(List<TrackedFinding> findingsAddedOnBranch, GerritConfigurationParameters gerritConfigurationParameters) {
            this.findingsAddedOnBranch = findingsAddedOnBranch;
            this.findingsRelevantForComments = FilteredFindings.calculateFindingsRelevantForComments(findingsAddedOnBranch, gerritConfigurationParameters.isIgnoreYellowFindingsForCommentsEnabled);
            this.findingsRelevantForVotes = FilteredFindings.categorizeFindings(findingsAddedOnBranch);
        }

        private static ListMap<ETrafficLightColor, TrackedFinding> categorizeFindings(List<TrackedFinding> findingsAddedOnBranch) {
            return (ListMap)findingsAddedOnBranch.stream().collect(ListMapCollector.groupingBy(DetachedFinding::getAssessment));
        }

        private static List<TrackedFinding> calculateFindingsRelevantForComments(List<TrackedFinding> findings, boolean ignoreYellow) {
            return findings.stream().filter(finding -> !ignoreYellow || finding.getAssessment() == ETrafficLightColor.RED).collect(Collectors.toList());
        }

        private void applyFilter(Predicate<TrackedFinding> filterPredicate) {
            this.findingsRelevantForVotes.removeIf(finding -> !filterPredicate.test((TrackedFinding)finding));
            this.findingsRelevantForComments.removeIf(finding -> !filterPredicate.test((TrackedFinding)finding));
        }

        private boolean hasNoFindingsForVoting() {
            return ((List)this.findingsRelevantForVotes.getValues()).isEmpty();
        }

        private boolean hasNoRedFindingsForVoting() {
            return ((List)this.findingsRelevantForVotes.getCollectionOrEmpty((Object)ETrafficLightColor.RED)).isEmpty();
        }
    }

    private static class ExistingPaths {
        private final Set<UniformPath> set = new HashSet<UniformPath>();

        private ExistingPaths() {
        }

        private void handleEntry(RepositoryLogFileHistoryEntry historyEntry) {
            switch (historyEntry.getChangeType()) {
                case DELETE: {
                    this.set.remove(historyEntry.getUniformPath());
                    break;
                }
                case MOVE: {
                    this.set.remove(UniformPathCompatibilityUtil.convert((String)historyEntry.getOriginPath()));
                    this.set.add(historyEntry.getUniformPath());
                    break;
                }
                case ADD: 
                case EDIT: 
                case COPY: {
                    this.set.add(historyEntry.getUniformPath());
                    break;
                }
            }
        }
    }
}

