/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.gerrit.data.CommentInfo;
import com.teamscale.index.repository.git.gerrit.data.LabelInfo;
import com.teamscale.index.repository.git.gerrit.data.RevisionInfo;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ChangeInfo {
    private static final String ID_PROPERTY = "id";
    private static final String PROJECT_PROPERTY = "project";
    private static final String BRANCH_PROPERTY = "branch";
    private static final String CHANGE_ID_PROPERTY = "change_id";
    private static final String REVISIONS_PROPERTY = "revisions";
    private static final String LABELS_PROPERTY = "labels";
    private static final String STATUS_PROPERTY = "status";
    private static final String NUMBER_PROPERTY = "_number";
    private static final String MESSAGES_PROPERTY = "messages";
    private static final String CREATED_PROPERTY = "created";
    private static final String UPDATED_PROPERTY = "updated";
    private static final String MORE_CHANGES_PROPERTY = "_more_changes";
    static final String GERRIT_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.nnnnnnnnn";
    static final DateTimeFormatter GERRIT_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.nnnnnnnnn");
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="project")
    private final String project;
    @JsonProperty(value="branch")
    private final String branch;
    @JsonProperty(value="change_id")
    private final String changeId;
    @JsonProperty(value="revisions")
    private final Map<String, RevisionInfo> revisions;
    @JsonProperty(value="labels")
    private final Map<String, LabelInfo> labels;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="_number")
    private final Long number;
    @JsonProperty(value="messages")
    private final List<CommentInfo> messages;
    public static final String STATUS_MERGED = "MERGED";
    public static final String STATUS_ABANDONED = "ABANDONED";
    @JsonProperty(value="created")
    private final String created;
    @JsonProperty(value="updated")
    private final String updated;
    @JsonProperty(value="_more_changes")
    private final boolean moreChanges;

    @JsonCreator
    public ChangeInfo(@JsonProperty(value="id") String id, @JsonProperty(value="project") String project, @JsonProperty(value="branch") String branch, @JsonProperty(value="change_id") String changeId, @JsonProperty(value="revisions") Map<String, RevisionInfo> revisions, @JsonProperty(value="labels") Map<String, LabelInfo> labels, @JsonProperty(value="status") String status, @JsonProperty(value="_number") Long number, @JsonProperty(value="messages") List<CommentInfo> messages, @JsonProperty(value="created") String created, @JsonProperty(value="updated") String updated, @JsonProperty(value="_more_changes") boolean moreChanges) {
        this.id = id;
        this.project = project;
        this.branch = branch;
        this.changeId = changeId;
        this.revisions = revisions;
        this.labels = labels;
        this.status = status;
        this.number = number;
        this.messages = messages;
        this.created = created;
        this.updated = updated;
        this.moreChanges = moreChanges;
    }

    public Instant getCreationInstant() {
        return LocalDateTime.parse(this.created, GERRIT_TIMESTAMP_FORMATTER).toInstant(ZoneOffset.UTC);
    }

    public Instant getUpdatedInstant() {
        return LocalDateTime.parse(this.updated, GERRIT_TIMESTAMP_FORMATTER).toInstant(ZoneOffset.UTC);
    }

    public Optional<RevisionInfo> getCurrentRevisionInfo() {
        return this.revisions.values().stream().max(Comparator.comparing(RevisionInfo::getCreationInstant));
    }

    public String getChangeId() {
        return this.changeId;
    }

    public boolean isMoreChanges() {
        return this.moreChanges;
    }

    public String getId() {
        return this.id;
    }

    public String getProject() {
        return this.project;
    }

    public String getBranch() {
        return this.branch;
    }

    public Map<String, RevisionInfo> getRevisions() {
        return this.revisions;
    }

    public Map<String, LabelInfo> getLabels() {
        return this.labels;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getNumber() {
        return this.number;
    }

    public List<CommentInfo> getMessages() {
        return this.messages;
    }

    public String getCreated() {
        return this.created;
    }

    public String getUpdated() {
        return this.updated;
    }

    public String toString() {
        return "ChangeInfo{id='" + this.id + "', project='" + this.project + "', branch='" + this.branch + "', changeId='" + this.changeId + "', revisions=" + String.valueOf(this.revisions) + ", labels=" + String.valueOf(this.labels) + ", status='" + this.status + "', number=" + this.number + ", created='" + this.created + "', updated='" + this.updated + "', moreChanges=" + this.moreChanges + "}";
    }
}

