/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.ScheduleOption;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.repository.git.github.GitHubCheckRunMaintenanceTrigger;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="repository.github.check-run-cleanup", name="GitHub Check Run Cleanup", type=EOptionType.SERVER, category=EOptionCategory.GITHUB)
@IndexValueClass(containedInBackup=true)
public class GitHubCheckRunCleanupOption
implements IOption {
    private static final long serialVersionUID = 1L;
    protected static final String OPTION_ID = "repository.github.check-run-cleanup";
    protected static final String OPTION_NAME = "GitHub Check Run Cleanup";
    private static final String AT_MIDNIGHT = "@midnight";
    @JsonProperty(value="enabled")
    @OptionFieldDescription(name="GitHub Check Run Cleanup", description="Schedules regular check run cleanups, closing any leftover pending check runs. Leave empty to disable. Note: only works as longs as this exact instance created the check-run, backup imports will not carry over this information to new instances.")
    @ScheduleOption(triggerClass=GitHubCheckRunMaintenanceTrigger.class)
    public String schedule = "";

    public static void enable(IndexLayer indexLayer) throws StorageException {
        Optional<String> schedule = GitHubCheckRunCleanupOption.getSchedule(indexLayer);
        if (schedule.isPresent() && !schedule.get().equals("")) {
            return;
        }
        GitHubCheckRunCleanupOption.setOption(indexLayer, AT_MIDNIGHT);
    }

    public static void disable(IndexLayer indexLayer) throws StorageException {
        Optional<String> schedule = GitHubCheckRunCleanupOption.getSchedule(indexLayer);
        if (schedule.isPresent() && !schedule.get().equals(AT_MIDNIGHT)) {
            return;
        }
        GitHubCheckRunCleanupOption.setOption(indexLayer, "");
    }

    private static void setOption(IndexLayer indexLayer, String schedule) throws StorageException {
        GitHubCheckRunCleanupOption option = new GitHubCheckRunCleanupOption();
        option.schedule = schedule;
        ServerOptionRegistry.getInstance().putOption("server", OPTION_ID, null, (IOption)option, (OptionIndexBase)indexLayer.openGlobalIndex(ServerOptionIndex.class));
    }

    private static Optional<String> getSchedule(IndexLayer indexLayer) throws StorageException {
        GitHubCheckRunCleanupOption serverOption = (GitHubCheckRunCleanupOption)ServerOptionRegistry.getInstance().getServerOption(OPTION_ID, GitHubCheckRunCleanupOption.class, (ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class));
        return Optional.ofNullable(serverOption).map(option -> option.schedule);
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) {
        return null;
    }
}

