/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.index;

import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.GitHubCommitStatus;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="github-webhook-payloads", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED}, valueClasses={byte[].class})
public class GitHubWebhookPayloadIndex
implements IProjectIndex {
    private final ValueIndex<GitHubPullRequest> mergeRequestDelegateIndex;
    private final ValueIndex<HashSet<CheckRun>> checkRunDelegateIndex;
    private final ValueIndex<HashSet<GitHubCommitStatus>> commitStatusDelegateIndex;
    private static final String MERGE_REQUESTS_PREFIX = "mr";
    private static final String CHECK_RUNS_PREFIX = "cr";
    private static final String COMMIT_STATUS_PREFIX = "cs";

    public GitHubWebhookPayloadIndex(IStore store) {
        this.mergeRequestDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, MERGE_REQUESTS_PREFIX));
        this.checkRunDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, CHECK_RUNS_PREFIX));
        this.commitStatusDelegateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, COMMIT_STATUS_PREFIX));
    }

    public void addPullRequestFromPayload(MergeRequestIdentifier identifier, GitHubPullRequest pullRequest) throws StorageException {
        this.mergeRequestDelegateIndex.setValue(GitHubWebhookPayloadIndex.createMergeRequestKey(identifier), (Object)pullRequest);
    }

    public void addPullRequestsFromPayload(String repositoryName, List<GitHubPullRequest> pullRequests) throws StorageException {
        PairList values = (PairList)pullRequests.stream().collect(PairList.toPairList(pr -> GitHubWebhookPayloadIndex.createMergeRequestKey(new MergeRequestIdentifier(repositoryName, (long)pr.number())), Function.identity()));
        this.mergeRequestDelegateIndex.setValues(values);
    }

    public void addCheckRunFromPayload(String headCommitSha, CheckRun checkRun) throws StorageException {
        this.addCheckRunsToDelegateIndex(headCommitSha, List.of(checkRun));
    }

    public void addCheckRunsFromPayload(String headCommitSha, List<CheckRun> checkRuns) throws StorageException {
        this.addCheckRunsToDelegateIndex(headCommitSha, checkRuns);
    }

    private void addCheckRunsToDelegateIndex(String headCommitSha, List<CheckRun> items) throws StorageException {
        GitHubWebhookPayloadIndex.addItemsToDelegateIndex(headCommitSha, items, this.checkRunDelegateIndex, GitHubWebhookPayloadIndex::createCheckRunKey);
    }

    private static int createCheckRunKey(CheckRun checkRun) {
        return Objects.hash(checkRun.name(), checkRun.headSha());
    }

    public void addCommitStatusFromPayload(String headCommitSha, GitHubCommitStatus commitStatus) throws StorageException {
        this.addCommitStatusesToDelegateIndex(headCommitSha, List.of(commitStatus));
    }

    public void addCommitStatusesFromPayload(String headCommitSha, List<GitHubCommitStatus> commitStatus) throws StorageException {
        this.addCommitStatusesToDelegateIndex(headCommitSha, commitStatus);
    }

    private void addCommitStatusesToDelegateIndex(String headCommitSha, List<GitHubCommitStatus> items) throws StorageException {
        GitHubWebhookPayloadIndex.addItemsToDelegateIndex(headCommitSha, items, this.commitStatusDelegateIndex, GitHubWebhookPayloadIndex::createCommitStatusKey);
    }

    private static int createCommitStatusKey(GitHubCommitStatus commitStatus) {
        return Objects.hash(commitStatus.context());
    }

    private static <T> void addItemsToDelegateIndex(String headCommitSha, List<T> items, ValueIndex<HashSet<T>> delegateIndex, Function<T, Integer> keyGenerator) throws StorageException {
        Set existingValues = Objects.requireNonNullElseGet((Set)delegateIndex.getValue(headCommitSha), Collections::emptySet);
        Map updatedValues = existingValues.stream().collect(Collectors.toMap(keyGenerator, Function.identity()));
        items.forEach(item -> updatedValues.put((Integer)keyGenerator.apply(item), item));
        delegateIndex.setValue(headCommitSha, new HashSet(updatedValues.values()));
    }

    public @Nullable GitHubPullRequest getPullRequest(MergeRequestIdentifier identifier) throws StorageException {
        return (GitHubPullRequest)this.mergeRequestDelegateIndex.getValue(GitHubWebhookPayloadIndex.createMergeRequestKey(identifier));
    }

    public @NonNull Set<CheckRun> getCheckRuns(String headCommitSha) throws StorageException {
        HashSet checkRuns = (HashSet)this.checkRunDelegateIndex.getValue(headCommitSha);
        if (checkRuns == null) {
            return Collections.emptySet();
        }
        return new HashSet<CheckRun>(checkRuns);
    }

    public @NonNull Set<GitHubCommitStatus> getCommitStatuses(String headCommitSha) throws StorageException {
        HashSet commitStatuses = (HashSet)this.commitStatusDelegateIndex.getValue(headCommitSha);
        if (commitStatuses == null) {
            return Collections.emptySet();
        }
        return new HashSet<GitHubCommitStatus>(commitStatuses);
    }

    private static String createMergeRequestKey(MergeRequestIdentifier identifier) {
        return MergeRequestIndex.sanitizeRepositoryName(identifier.repositoryName()) + "#" + identifier.id();
    }
}

