/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.date.DateTimeUtils;

public class PolarionQueryBuilder {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeUtils.createDateTimeFormatter((String)"yyyyMMdd");
    private final StringBuilder query = new StringBuilder();

    public PolarionQueryBuilder updatedAfter(long baselineTimestamp) {
        String baselineDate = DATE_FORMATTER.format(Instant.ofEpochMilli(baselineTimestamp).atZone(ZoneOffset.MIN));
        this.query.append("updated:[").append(baselineDate).append(" TO $today$]");
        return this;
    }

    public PolarionQueryBuilder and() {
        this.query.append(" AND ");
        return this;
    }

    public PolarionQueryBuilder withModuleId(String location, List<String> moduleNames) {
        return this.withModuleIds(Map.of(location, moduleNames));
    }

    public PolarionQueryBuilder withModuleIds(Map<String, ? extends Iterable<String>> moduleNamesForLocation) {
        this.query.append("document.id: (");
        for (Map.Entry<String, ? extends Iterable<String>> entry : moduleNamesForLocation.entrySet()) {
            String location = entry.getKey();
            Iterable<String> moduleNames = entry.getValue();
            for (String moduleName : moduleNames) {
                this.query.append("\"").append(location).append("/").append(moduleName).append("\" ");
            }
        }
        this.query.append(")");
        return this;
    }

    public String build() {
        return this.query.toString();
    }
}

