/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.code_links;

import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.code_links.ICodeLinkProvider;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

public class TypeDependencyLinkProvider
implements ICodeLinkProvider {
    @Override
    public void registerLinks(FormattedTokenElementInfo targetInfo, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) throws StorageException {
        if (!projectStorageSystem.hasIndex("type-dependencies")) {
            return;
        }
        TypeIndex typeIndex = (TypeIndex)projectStorageSystem.openProjectIndex(TypeIndex.class, historyAccessOption);
        TypeDependencyIndex typeDependencyIndex = (TypeDependencyIndex)projectStorageSystem.openProjectIndex(TypeDependencyIndex.class, historyAccessOption);
        List<TypeDependencies> dependencies = typeDependencyIndex.getTypeDependencies(targetInfo.getUniformPath());
        if (dependencies == null) {
            return;
        }
        for (TypeDependencies typeDependencies : dependencies) {
            Map<String, List<ElementLocation>> dependencyLocations = typeDependencies.getDependencyLocations();
            TypeDependencyLinkProvider.mapTokensToLocations(typeIndex, dependencyLocations, targetInfo);
        }
    }

    private static void mapTokensToLocations(TypeIndex typeIndex, Map<String, List<ElementLocation>> dependencyLocations, FormattedTokenElementInfo targetInfo) throws StorageException {
        for (Map.Entry<String, List<ElementLocation>> entry : dependencyLocations.entrySet()) {
            String dependencyTargetType = entry.getKey();
            List<String> dependencyTargetFiles = typeIndex.getFilesForTypes(Collections.singletonList(dependencyTargetType)).get(0);
            if (dependencyTargetFiles.isEmpty()) continue;
            String uniformPath = dependencyTargetFiles.get(0);
            ElementLocation linkTarget = new ElementLocation(uniformPath);
            List<ElementLocation> dependencySourceLocations = entry.getValue();
            for (ElementLocation dependencySourceLocation : dependencySourceLocations) {
                TypeDependencyLinkProvider.registerLinkFromDependencySourceToTarget(targetInfo, dependencySourceLocation, linkTarget);
            }
        }
    }

    private static void registerLinkFromDependencySourceToTarget(FormattedTokenElementInfo targetInfo, ElementLocation dependencySourceLocation, ElementLocation linkTarget) {
        if (dependencySourceLocation instanceof TextRegionLocation) {
            String rawTextAtOffset;
            int rawStartOffset = ((TextRegionLocation)dependencySourceLocation).getRawStartOffset();
            if (CPreprocessingUtils.C_PREPROCESSOR_LANGUAGES.contains(targetInfo.getLanguage()) && ((rawTextAtOffset = targetInfo.getText().substring(rawStartOffset)).startsWith("#include") || rawTextAtOffset.startsWith("#include_next") || rawTextAtOffset.startsWith("#import"))) {
                return;
            }
            targetInfo.mapTokenToLocation(rawStartOffset, linkTarget);
        }
    }
}

