/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.code_links;

import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.code_links.ICodeLinkProvider;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorFactory;
import eu.cqse.check.framework.typetracker.TypedVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class VariableDefinitionLinkProvider
implements ICodeLinkProvider {
    @Override
    public void registerLinks(FormattedTokenElementInfo tokenElementInfo, ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyAccessOption) {
        if (!TypeInfoExtractorFactory.supportsLanguage((ELanguage)tokenElementInfo.getLanguage())) {
            return;
        }
        UnmodifiableList<ShallowEntity> entities = tokenElementInfo.getShallowEntitiesWithoutPreprocessorTokens();
        ITypeInfoExtractor extractor = TypeInfoExtractorFactory.getTypeInfoExtractor((ELanguage)tokenElementInfo.getLanguage(), entities);
        VariableDefinitionLinkProvider.addVariableDefinitionInfo(entities, extractor, tokenElementInfo, new HashMap<String, ShallowEntity>());
    }

    private static void addVariableDefinitionInfo(List<ShallowEntity> entities, ITypeInfoExtractor extractor, FormattedTokenElementInfo tokenElementInfo, Map<String, ShallowEntity> statementListScope) {
        for (ShallowEntity entity : entities) {
            Map<String, ShallowEntity> currentScope = statementListScope;
            if (entity.hasChildren() || entity.getType() == EShallowEntityType.METHOD) {
                currentScope = new HashMap<String, ShallowEntity>(statementListScope);
            }
            List variables = extractor.extract(entity);
            for (TypedVariable variable : variables) {
                currentScope.put(variable.getVariableName(), entity);
            }
            if (entity.hasChildren()) {
                VariableDefinitionLinkProvider.mapEntitiesOwnEndTokensToFile(tokenElementInfo, entity, currentScope);
            }
            VariableDefinitionLinkProvider.addVariableDefinitionInfo((List<ShallowEntity>)entity.getChildren(), extractor, tokenElementInfo, new HashMap<String, ShallowEntity>(currentScope));
        }
    }

    private static void mapEntitiesOwnEndTokensToFile(FormattedTokenElementInfo tokenElementInfo, ShallowEntity entity, Map<String, ShallowEntity> currentScope) {
        for (IToken token : entity.ownEndTokens()) {
            ShallowEntity definitionEntity;
            if (token.getType() != ETokenType.IDENTIFIER || (definitionEntity = currentScope.get(token.getText())) == null) continue;
            tokenElementInfo.mapTokenToFile(token, tokenElementInfo.getUniformPath(), definitionEntity.getStartLine());
        }
    }
}

