/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.google.common.annotations.VisibleForTesting;
import com.teamscale.core.config.TeamscaleSystemProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

final class S3RegionUtils {
    private static final List<String> CUSTOM_REGION_NAMES;

    public static Region extractRegionFromBaseUri(String baseUri) {
        return S3RegionUtils.extractRegionFromUri(baseUri, CUSTOM_REGION_NAMES);
    }

    private static Optional<Region> getRegion() {
        try {
            Optional awsRegionProperty = TeamscaleSystemProperties.AWS_REGION.getValue();
            return awsRegionProperty.map(Region::of).or(() -> Optional.ofNullable(DefaultAwsRegionProviderChain.builder().build().getRegion()));
        }
        catch (SdkException e) {
            return Optional.empty();
        }
    }

    private static Region getDefaultRegion() {
        return Region.US_WEST_2;
    }

    private static void disableAWSWarnLogs() {
        Configurator.setLevel((String)"software.amazon", (Level)Level.DEBUG);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig loggerConfig = ctx.getConfiguration().getLoggerConfig("software.amazon");
        loggerConfig.addFilter((Filter)new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                if (event.getLevel() == Level.INFO || event.getLevel() == Level.WARN) {
                    return Filter.Result.DENY;
                }
                return Filter.Result.NEUTRAL;
            }
        });
        ctx.updateLoggers();
    }

    @VisibleForTesting
    static @NonNull Region extractRegionFromUri(@NonNull String uri, @NonNull List<String> customRegionNames) {
        for (Region region : Region.regions()) {
            if (!StringUtils.containsIgnoreCase((String)uri, (String)region.id())) continue;
            return region;
        }
        for (String customRegionName : customRegionNames) {
            if (!StringUtils.containsIgnoreCase((String)uri, (String)customRegionName)) continue;
            return Region.of((String)customRegionName);
        }
        if (EFeatureToggle.ENABLE_TEST_MODE.isEnabled()) {
            return S3RegionUtils.getDefaultRegion();
        }
        return S3RegionUtils.getRegion().orElse(S3RegionUtils.getDefaultRegion());
    }

    @VisibleForTesting
    static @NonNull List<String> parseCustomRegionNames(@Nullable String customAwsRegionProperty) {
        if (StringUtils.isEmpty((String)customAwsRegionProperty)) {
            return Collections.emptyList();
        }
        ArrayList<String> customRegionNames = new ArrayList<String>();
        for (String regionName : customAwsRegionProperty.split(",")) {
            if (StringUtils.isEmpty((String)regionName)) continue;
            customRegionNames.add(regionName.trim());
        }
        return customRegionNames;
    }

    private S3RegionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    static {
        S3RegionUtils.disableAWSWarnLogs();
        CUSTOM_REGION_NAMES = S3RegionUtils.parseCustomRegionNames((String)TeamscaleSystemProperties.CUSTOM_AWS_REGIONS.getValue());
    }
}

