/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.component;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.stacktrace.component.IStacktraceComponent;
import com.teamscale.index.stacktrace.component.Location;
import com.teamscale.index.stacktrace.visitor.IStacktraceVisitor;
import java.util.Objects;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class StackFrame
implements IStacktraceComponent {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="className")
    private String className;
    @JsonProperty(value="methodName")
    private String methodName;
    @JsonProperty(value="location")
    private @Nullable Location location;
    @JsonProperty(value="uniformPath")
    private @Nullable String uniformPath;

    public String getUniformPath() {
        return this.uniformPath;
    }

    public void setUniformPath(String uniformPath) {
        this.uniformPath = uniformPath;
    }

    private StackFrame() {
        this.className = "";
        this.methodName = "";
        this.location = null;
        this.uniformPath = null;
    }

    private StackFrame(String className, String methodName, Location location, String uniformPath) {
        this.className = className;
        this.methodName = methodName;
        this.location = location;
        this.uniformPath = uniformPath;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public String getStringRepresentation(int nestingLevel) {
        String indentation = StringUtils.fillString((int)nestingLevel, (char)'\t');
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(indentation + "[StackFrame className=\"" + this.className + "\" methodName=\"" + this.methodName + "\"");
        if (this.location != null) {
            stringBuilder.append(this.location);
        } else {
            stringBuilder.append(" <Unknown Source>");
        }
        if (this.uniformPath != null && this.location != null) {
            stringBuilder.append(" uniformPath=\"" + this.uniformPath + "\"");
        }
        stringBuilder.append(" /]" + StringUtils.LINE_SEPARATOR);
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getStringRepresentation(0);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.location, this.uniformPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        StackFrame other = (StackFrame)o;
        return Objects.equals(this.className, other.className) && Objects.equals(this.methodName, other.methodName) && Objects.equals(this.location, other.location) && Objects.equals(this.uniformPath, other.uniformPath);
    }

    public static StackFrame withLocation(String className, String methodName, Location location) {
        return new StackFrame(className, methodName, location, null);
    }

    public static StackFrame withoutLocation(String className, String methodName) {
        return new StackFrame(className, methodName, null, null);
    }

    @Override
    public void accept(IStacktraceVisitor stacktraceVisitor) {
        stacktraceVisitor.visit(this);
    }
}

