/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.tokenizer;

import com.teamscale.index.stacktrace.tokenizer.EStacktraceTokenType;
import com.teamscale.index.stacktrace.tokenizer.token.IStacktraceToken;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StacktraceTokenizer {
    private static final String TOKEN_DELIMITER = "[\r\n]+";
    private final EnumSet<EStacktraceTokenType> tokenTypes;

    public StacktraceTokenizer(EnumSet<EStacktraceTokenType> tokenTypes) {
        this.tokenTypes = tokenTypes;
    }

    private static List<String> extractTokenCandidates(String input) {
        return Pattern.compile(TOKEN_DELIMITER).splitAsStream(input).map(String::trim).collect(Collectors.toList());
    }

    public List<IStacktraceToken> getTokens(String input) throws StacktraceTokenizerException {
        List<String> tokenCandidates = StacktraceTokenizer.extractTokenCandidates(input);
        ArrayList<IStacktraceToken> tokens = new ArrayList<IStacktraceToken>();
        for (String tokenCandidate : tokenCandidates) {
            boolean matchFound = false;
            for (EStacktraceTokenType currentTokenType : this.tokenTypes) {
                Matcher matcher = Pattern.compile(currentTokenType.getRegularExpression()).matcher(tokenCandidate);
                if (!matcher.matches()) continue;
                tokens.add(currentTokenType.getTokenCreationFunction().apply(matcher));
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            throw new StacktraceTokenizerException("No matching token type found for \"" + tokenCandidate + "\".");
        }
        return tokens;
    }

    public static class StacktraceTokenizerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private StacktraceTokenizerException(String message) {
            super(message);
        }
    }
}

