/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.index.system_info.SystemInfoEntry;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.test.IndexValueClass;
import oshi.software.os.OperatingSystem;

@IndexValueClass
public class OperatingSystemInfoFragment
extends SystemInfoFragmentBase {
    private static final long serialVersionUID = 1L;
    private final String vendor;
    private final String name;
    private final String version;

    public OperatingSystemInfoFragment(OperatingSystem os) {
        super(Long.MAX_VALUE);
        this.vendor = os.getManufacturer();
        this.name = os.getFamily();
        this.version = os.getVersionInfo().getVersion();
    }

    @Override
    public String getFragmentCaption() {
        return "Operating System";
    }

    @Override
    public int getFragmentOrder() {
        return 3;
    }

    @Override
    public List<SystemInfoEntry> convertToKeyValuePairs() {
        ArrayList<SystemInfoEntry> result = new ArrayList<SystemInfoEntry>();
        result.add(SystemInfoEntry.ofString("Vendor", this.vendor));
        result.add(SystemInfoEntry.ofString("Name", this.name));
        result.add(SystemInfoEntry.ofString("Version", this.version));
        return result;
    }

    public String getDescription() {
        return this.vendor + " " + this.name + " " + this.version;
    }
}

